# Code Submission README

## 1. Source  
This implementation builds on the AbsGS [[Ye et al., 2024]](https://github.com/TY424/AbsGS) and 3DGS [[Kerbl et al., 2023]](https://github.com/graphdeco-inria/gaussian-splatting).

## 2. Environment Setup  
Use the provided `environment.yml` file to create and install the conda environment:

```bash
conda env create -f environment.yml
conda activate DC4GS
```

## 3. Usage  
Replace items in braces `{}` with your actual values when running the commands.

### 3.1 Training

```bash
OMP_NUM_THREADS=4 \
CUDA_VISIBLE_DEVICES={gpu_idx} \
python train-dcc.py \
  -s {dataset_dir} \
  -m {output_dir} \
  -i images or images_{scale} \
  --eval \
  --without_bound
```

- `{gpu_idx}`: GPU index to use  
- `{dataset_dir}`: Path to your dataset  
- `{output_dir}`: Directory to save checkpoints and logs  
- `images` or `images_{scale}`: Folder of original images or scaled images  

### 3.2 Rendering & Evaluation

```bash
OMP_NUM_THREADS=4 \
CUDA_VISIBLE_DEVICES={gpu_idx} \
python metrics.py \
  -m {output_dir} \
  --skip_train
```

## 4. References

```bibtex
@Article{kerbl3Dgaussians,
    author = {Kerbl, Bernhard and Kopanas, Georgios and Leimk{\"u}hler, Thomas and Drettakis, George},
    title        = {3D Gaussian Splatting for Real-Time Radiance Field Rendering},
    journal      = {ACM Transactions on Graphics},
    number       = {4},
    volume       = {42},
    month        = {July},
    year         = {2023},
    url          = {https://repo-sam.inria.fr/fungraph/3d-gaussian-splatting/}
}

@inproceedings{ye2024absgs,
    title       = {AbsGS: Recovering fine details in 3d gaussian splatting},
    author      = {Ye, Zongxin and Li, Wenyu and Liu, Sidun and Qiao, Peng and Dou, Yong},
    booktitle   = {ACM Int. Conf. Multimedia},
    pages       = {1053--1061},
    year        = {2024}
}
```
