import json
import glob
import GPUtil
import os
import sys
import tqdm

import deepobs
from deepobs import tensorflow as tfobs

import utils


def main():
    with open(sys.argv[1]) as f:
        contents = json.load(f)
    sys.argv = sys.argv[:1]

    for run in tqdm.tqdm(contents):
        optimizer_class = utils.optimizers[run["optimizer_name"]]
        hyperparams = utils.hyperparams[run["optimizer_name"]]
        runner = tfobs.runners.StandardRunner(optimizer_class, hyperparams)

        runner.run(
            skip_if_exists=True,
            # tb_log=True,
            # train_log_interval=50,
            # print_train_iter=True,
            **run["runner_params"],
        )


if __name__ == "__main__":
    device = GPUtil.getAvailable(limit=float("inf"), maxLoad=0.1, maxMemory=0.1)[0]
    os.environ["CUDA_VISIBLE_DEVICES"] = str(device)
    main()
