# OpenAI GPT 
from openai import OpenAI
from common.constants import API_INFOS, ALI_API_MODELS, GOOGLE_API_MODELS, DEEPSEEK_API_MODELS, \
                             OPENAI_API_MODELS, ANTHROPIC_API_MODELS, XAI_API_MODELS, ZHIPU_API_MODELS, \
                             MINIMAX_API_MODELS, MOONSHOT_API_MODELS, SPARK_API_MODELS, ARK_API_MODELS


def get_client(model_name):
    if model_name in ALI_API_MODELS:
        client = get_ali_client(
                api_key=API_INFOS[model_name]['api_key'],
                base_url=API_INFOS[model_name]['base_url'],
            )
    elif model_name in DEEPSEEK_API_MODELS:
        client = get_deepseek_client(
                api_key=API_INFOS[model_name]['api_key'],
                base_url=API_INFOS[model_name]['base_url'],
            )
    elif model_name in GOOGLE_API_MODELS:
        client = get_genai_client(
                api_key=API_INFOS[model_name]['api_key'],
            )
    elif model_name in OPENAI_API_MODELS:
        client = get_openai_client(
                api_key=API_INFOS[model_name]['api_key'],
            )
    elif model_name in ANTHROPIC_API_MODELS:
        client = get_anthropic_client(
                api_key=API_INFOS[model_name]['api_key'],
            )
    elif model_name in XAI_API_MODELS:
        client = get_xai_client(
                api_key=API_INFOS[model_name]['api_key'],
            )
    elif model_name in ZHIPU_API_MODELS:
        client = get_zhipuai_client(
                api_key=API_INFOS[model_name]['api_key'],
            )
    elif model_name in MINIMAX_API_MODELS:
        client = get_minimax_client(
                api_key=API_INFOS[model_name]['api_key'],
                base_url=API_INFOS[model_name]['base_url'],
            )
    elif model_name in MOONSHOT_API_MODELS:
        client = get_moonshot_client(
                api_key=API_INFOS[model_name]['api_key'],
                base_url=API_INFOS[model_name]['base_url'],
            )
    elif model_name in SPARK_API_MODELS:
        client = get_spark_client(
                api_key=API_INFOS[model_name]['api_key'],
                base_url=API_INFOS[model_name]['base_url'],
            )
    elif model_name in ARK_API_MODELS:
        client = get_ark_client(
                api_key=API_INFOS[model_name]['api_key'],
                base_url=API_INFOS[model_name]['base_url'],
            )
    return client


_openai_client = None

def get_openai_client(api_key=None, base_url=None):
    global _openai_client
    if _openai_client is None:
        if base_url is None:
            _openai_client = OpenAI(
                api_key=api_key
            )
        else:
            _openai_client = OpenAI(
                api_key=api_key,
                base_url=base_url 
            )
    return _openai_client


_ali_client = None

def get_ali_client(api_key=None, base_url=None):
    global _ali_client
    if _ali_client is None:
        if base_url is None:
            _ali_client = OpenAI(
                api_key=api_key
            )
        else:
            _ali_client = OpenAI(
                api_key=api_key,
                base_url=base_url 
            )
    return _ali_client



_deepseek_client = None

def get_deepseek_client(api_key=None, base_url=None):
    global _deepseek_client
    if _deepseek_client is None:
        if base_url is None:
            _deepseek_client = OpenAI(
                api_key=api_key
            )
        else:
            _deepseek_client = OpenAI(
                api_key=api_key,
                base_url=base_url 
            )
    return _deepseek_client


# Google Gemini
from google import genai

_genai_client = None

def get_genai_client(api_key=None):
    global _genai_client
    if _genai_client is None:
        if api_key is None:
            raise ValueError("API key is required for GenAI client.")
        _genai_client = genai.Client(api_key=api_key)
    return _genai_client


# Anthropic Claude
import httpx
from anthropic import Anthropic, DefaultHttpxClient

_anthropic_client = None

def get_anthropic_client(api_key=None):
    global _anthropic_client
    if _anthropic_client is None:
        if api_key is None:
            raise ValueError("API key is required for Anthropic client.")
        _anthropic_client = Anthropic(api_key=api_key)
        
    return _anthropic_client


# Llama
_llama_client = None

def get_llama_client(api_key=None):
    global _llama_client
    if _llama_client is None:
        if api_key is None:
            raise ValueError("API key is required for Llama client.")
        _llama_client = OpenAI(
            api_key=api_key,
        )
    return _llama_client


# XAI Grok
_xai_client = None

import xai_sdk
def get_xai_client(api_key=None):
    global _xai_client
    if _xai_client is None:
        if api_key is None:
            raise ValueError("API key is required for XAI client.")
        _xai_client = xai_sdk.Client(
            api_key=api_key,
            timeout=3600,  # Override default timeout with longer timeout for reasoning models
        )
    return _xai_client


_zhipuai_client = None

from zai import ZhipuAiClient
def get_zhipuai_client(api_key=None):
    global _zhipuai_client
    if _zhipuai_client is None:
        if api_key is None:
            raise ValueError("API key is required for ZhipuAi client.")
        _zhipuai_client = ZhipuAiClient(api_key=api_key)
    return _zhipuai_client


_minimax_client = None

def get_minimax_client(api_key=None, base_url=None):
    global _minimax_client
    if _minimax_client is None:
        if api_key is None:
            raise ValueError("API key is required for MiniMax client.")
        if base_url is None:
            base_url = "https://api.minimaxi.com/v1"
        _minimax_client = OpenAI(
            api_key=api_key,
            base_url=base_url
        )
    return _minimax_client


_moonshot_client = None

def get_moonshot_client(api_key=None, base_url=None):
    global _moonshot_client
    if _moonshot_client is None:
        if api_key is None:
            raise ValueError("API key is required for Moonshot client.")
        if base_url is None:
            base_url = "https://api.moonshot.cn/v1"
        _moonshot_client = OpenAI(
            api_key=api_key,
            base_url=base_url
        )
    return _moonshot_client


_spark_client = None

def get_spark_client(api_key=None, base_url=None):
    global _spark_client
    if _spark_client is None:
        if api_key is None:
            raise ValueError("API key is required for Spark client.")
        if base_url is None:
            base_url = "https://spark-api-open.xf-yun.com/v2"
        _spark_client = OpenAI(
            api_key=api_key,
            base_url=base_url
        )
    return _spark_client


_ark_client = None

def get_ark_client(api_key=None, base_url=None):
    global _ark_client
    if _ark_client is None:
        if api_key is None:
            raise ValueError("API key is required for Ark client.")
        if base_url is None:
            base_url = "https://ark.cn-beijing.volces.com/api/v3"
        _ark_client = OpenAI(
            api_key=api_key,
            base_url=base_url,
        )
    return _ark_client