import hashlib
import json

def generate_hash(data: str, hash_algorithm: str = "sha256") -> str:
    serialized_data = data  
    hasher = hashlib.new(hash_algorithm)
    hasher.update(serialized_data.encode("utf-8"))
    return hasher.hexdigest()

def generate_cross_hash(data1: str, data2: str, hash_algorithm: str = "sha256") -> str:
    merged_data = data1 + data2
    serialized_data = json.dumps(
        merged_data,
        sort_keys=True,
        ensure_ascii=False,
        separators=(",", ":"),
        default=str
    )
    hasher = hashlib.new(hash_algorithm)
    hasher.update(serialized_data.encode("utf-8"))
    return hasher.hexdigest()
