import os

"""" regex patterns """
ANSWER_ANALYZE_REGS = r"(Reasoning Process:.*?)(Answer:.*)"
REASONING_PROCESS_REGS = r"Reasoning Process:(.*?)(?=\s*(?:Reasoning Process:|Answer:|$))"  
ANSWER_REGS = r"Answer:(.*?)(?=\n?\n?(?:Reasoning Process:|Answer:|$))" 
REASON_REGS = r"Reason:(.*?)(?=\n?\n?(?:Reason:|Error Pattern:|$))"

CHOICE_REGS=[
    r"^\(?([A-Z])\)?\.?"
]

BOOL_REGS=[
    r"\s*(?:\*\*)?\s*([Tt]rue|[Ff]alse)",
    r".?\\\(?\\text{(False|True)}\\\)?",
    r".{0,2}\\\(?.{0,2}\\{0,2}text.{0,2}{.{0,2}(False|True).{0,2}\\{0,2}\)?",
]

YES_NO_REGS=[
    r"\s*(?:\*\*)?\s*([Yy]es|[Nn]o)",
]

BRACKET_REGS=[
    r"([}\)]+)",
]

VALIDITY_REGS=[
    r'(?i)\b(valid|invalid)\b',
]

DATASET_TO_ANSWER_REGS = dict(
    mmlu_redux = CHOICE_REGS,
    mmlu = CHOICE_REGS,
) 


# math dataset
MATHEMATICAL_DATASETS = ['MATH-500', 'GSM8K', 'AIME2024', 'multistep_arithmetic_two', 'object_counting']
CHOICE_DATASETS = ['mmlu', 'mmlu-redux', 
                   'date_understanding', 'disambiguation_qa', 'geometric_shapes', 
                   'hyperbaton', 'logical_deduction_five_objects', 
                   'logical_deduction_seven_objects', 'logical_deduction_three_objects', 
                   'movie_recommendation', 'penguins_in_a_table', 
                   'reasoning_about_colored_objects', 'ruin_names', 
                   'salient_translation_error_detection', 'snarks', 
                   'temporal_sequences', 'tracking_shuffled_objects_five_objects', 
                   'tracking_shuffled_objects_seven_objects', 
                   'tracking_shuffled_objects_three_objects']

""" model lineage """
GEMINI_LINEAGE = ["gemini-2.5-flash", "gemini-2.5-pro",]
QWEN_LINEAGE = [ "qwen3-30b-a3b", "qwen3-32b", "qwen3-235b-a22b"]  
DEEPSEEK_LINEAGE = ["deepseek-chat", "deepseek-reasoner",]
OPENAI_LINEAGE = ["gpt-4o-2024-11-20", "gpt-4.1-nano-2025-04-14", "gpt-4.1-mini-2025-04-14", "gpt-4.1-2025-04-14",
                  "o3-2025-04-16", "o3-mini-2025-01-31",
                  "gpt-5-nano-2025-08-07", "gpt-5-mini-2025-08-07", "gpt-5-2025-08-07"]
CLAUDE_LINEAGE = ["claude-3-5-sonnet-20241022",
                  "claude-sonnet-4-20250514",
                  ]
GROK_LINEAGE = ["grok-3", "grok-4-0709"] # grok-4, grok-3-mini, and grok-3-mini-fast are reasoning-only models.
GLM_LINEAGE = ["glm-4.5-air" , "glm-4.5"]
MINIMAX_LINEAGE = ["MiniMax-Text-01",
                   "MiniMax-M1"]
KIMI_LINEAGE = ["kimi-k2-0711-preview"]
SPARK_LINEAGE = ["x1"] # x1 is Spark X1
DOUBAO_LINEAGE = ["doubao-seed-1-6-flash-250715", "doubao-seed-1-6-250615"]

""" API INFO """
OPENAI_API_MODELS = OPENAI_LINEAGE
ALI_API_MODELS = QWEN_LINEAGE
ANTHROPIC_API_MODELS = CLAUDE_LINEAGE
GOOGLE_API_MODELS = GEMINI_LINEAGE
DEEPSEEK_API_MODELS = DEEPSEEK_LINEAGE
XAI_API_MODELS = GROK_LINEAGE
ZHIPU_API_MODELS = GLM_LINEAGE
MINIMAX_API_MODELS = MINIMAX_LINEAGE
MOONSHOT_API_MODELS = KIMI_LINEAGE
SPARK_API_MODELS = SPARK_LINEAGE
ARK_API_MODELS = DOUBAO_LINEAGE


MODELS_ORDER = OPENAI_API_MODELS + ALI_API_MODELS + ANTHROPIC_API_MODELS + GOOGLE_API_MODELS + DEEPSEEK_API_MODELS \
               + XAI_API_MODELS + ZHIPU_API_MODELS + MINIMAX_API_MODELS + MOONSHOT_API_MODELS + SPARK_API_MODELS + \
                ARK_API_MODELS
MODELS_ORDER = {name: i for i, name in enumerate(MODELS_ORDER)}
TIME_ORDER = {
    "grok-4-0709": 0,
    "claude-sonnet-4-20250514": 1,
    "qwen3-235b-a22b": 2,
    "qwen3-32b": 3,
    "qwen3-30b-a3b": 4,
    "gemini-2.5-flash": 5,
    "o3-2025-04-16": 6,
    "gpt-4.1-2025-04-14": 7,
    "gpt-4.1-mini-2025-04-14": 8,
    "gpt-4.1-nano-2025-04-14": 9,
    "gemini-2.5-pro": 10,
    "grok-3": 11,
    "o3-mini-2025-01-31": 12,
    "deepseek-reasoner": 13,
    "deepseek-chat": 14,
    "gpt-4o-2024-11-20": 15,
    "claude-3-5-sonnet-20241022": 16
}
""" models need default temperature and top_p """
DEFAULT_TEMPERATURE_TOP_P_MODELS = []

API_INFOS = {}
for model in ALI_API_MODELS:
    API_INFOS[model] = dict(
        api_key = os.getenv("ALI_API_KEY"),
        base_url="https://dashscope.aliyuncs.com/compatible-mode/v1",
    )
for model in GOOGLE_API_MODELS:
    API_INFOS[model] = dict(
        api_key = os.getenv("GEMINI_API_KEY"),
    )
for model in OPENAI_API_MODELS:
    API_INFOS[model] = dict(
        api_key = os.getenv("OPENAI_API_KEY"),
    )
for model in ANTHROPIC_API_MODELS:
    API_INFOS[model] = dict(
        api_key = os.getenv("ANTHROPIC_API_KEY"),
    )
for model in DEEPSEEK_API_MODELS:
    API_INFOS[model] = dict(
        api_key = os.getenv("DEEPSEEK_API_KEY"),
        base_url="https://api.deepseek.com",
    )
for model in XAI_API_MODELS:
    API_INFOS[model] = dict(
        api_key = os.getenv("XAI_API_KEY"),
    )
for model in ZHIPU_API_MODELS:
    API_INFOS[model] = dict(
        api_key = os.getenv("ZAI_API_KEY"),
    )
for model in MINIMAX_API_MODELS:
    API_INFOS[model] = dict(
        api_key = os.getenv("MINIMAX_API_KEY"), 
        base_url="https://api.minimaxi.com/v1",
    )
for model in MOONSHOT_API_MODELS:
    API_INFOS[model] = dict(
        api_key = os.getenv("MOONSHOT_API_KEY"),
        base_url="https://api.moonshot.cn/v1",
    )
for model in SPARK_API_MODELS:
    API_INFOS[model] = dict(
        api_key = os.getenv("SPARK_API_KEY"),
        base_url="https://spark-api-open.xf-yun.com/v2",
    )
for model in ARK_API_MODELS:
    API_INFOS[model] = dict(
        api_key = os.getenv("ARK_API_KEY"),
        base_url="https://ark.cn-beijing.volces.com/api/v3",
    )