import pathlib

from utils.logger import get_logger

class BaseEvaluator:
    def __init__(self, dataset_name_from_hf, config_names, huggingface_cache, raw_results_dir: pathlib.Path, processed_results_dir: pathlib.Path, 
                 model_name, temperature=0, top_p=1, num_workers=4, cot_reasoning=True, question_type="common", answer_type="common", 
                 max_tokens=8192, thinking_budget=8192, enable_intrinsic_reasoning=False):
        
        self.dataset_name_from_hf = dataset_name_from_hf
        self.config_names = config_names
        self.huggingface_cache = huggingface_cache
        self.raw_results_dir = raw_results_dir
        self.processed_results_dir = processed_results_dir
        self.model_name = model_name
        self.temperature = temperature
        self.top_p = top_p
        self.num_workers = num_workers
        self.cot_reasoning = cot_reasoning
        self.question_type = question_type
        self.answer_type = answer_type
        self.max_tokens = max_tokens
        self.thinking_budget = thinking_budget
        self.enable_intrinsic_reasoning = enable_intrinsic_reasoning
        self.params = []
        self.logger = get_logger()
    
    def package_params(self):
        raise NotImplementedError("Subclasses should implement this method.")

    def run_query(self):
        raise NotImplementedError("Subclasses should implement this method.")

    def query_pipeline(self, params):
        raise NotImplementedError("Subclasses should implement this method.")

    def process_results(self):
        raise NotImplementedError("Subclasses should implement this method.")
    
    def run_all(self):
        self.package_params()
        self.run_query()
        self.process_results()