from common.constants import MATHEMATICAL_DATASETS
from evaluation import MATHEvaluator, MMLUReduxEvaluator, SimpleQAEvaluator


EVALUATOR_REGISTRY = {
    'MATH-500': {
        'evaluator_cls': MATHEvaluator,
        'question_type': 'common',
        'answer_type': 'math',
        'multi_subset': False,
    },
    'mmlu-redux': {
        'evaluator_cls': MMLUReduxEvaluator,
        'question_type': 'common',
        'answer_type': 'choice',
        'multi_subset': True,
    },
    'simple-qa': {
        'evaluator_cls': SimpleQAEvaluator,
        'question_type': 'common',
        'answer_type': 'common',
        'multi_subset': False,
    },
}
