import logging
import pathlib

_logger = None

def _initialize_logger(model_name, dataset_name, temperature, top_p, cot_reasoning, log_dir: pathlib.Path, specific_name=None):
    global _logger
    if _logger is None:
        if not specific_name:
            log_name = f"{model_name}-cot-temperature_{temperature}-top-p_{top_p}" if cot_reasoning else f"{model_name}-none-cot-temperature_{temperature}-top-p_{top_p}"
            log_file_path = log_dir.joinpath(f"{dataset_name}/{log_name}.log")
        else:
            log_file_path = log_dir.joinpath(f"{specific_name}.log")
        log_file_path.parent.mkdir(parents=True, exist_ok=True)

        logging.basicConfig(
            filename=log_file_path,
            filemode='a',
            format='%(asctime)s - %(levelname)s - %(message)s',
            level=logging.INFO
        )

        console = logging.StreamHandler()
        console.setLevel(logging.INFO)
        formatter = logging.Formatter('%(asctime)s - %(levelname)s - %(message)s')
        console.setFormatter(formatter)
        logging.getLogger('').addHandler(console)
        _logger = logging.getLogger(__name__)
        _logger.info("Logger is set up.")
        

def get_logger(model_name=None, dataset_name=None, temperature=None, top_p=None, cot_reasoning=None, log_dir=None, specific_name=None):
    # init logger when first call
    if _logger is None:
        if model_name and dataset_name and temperature is not None and top_p is not None:
            _initialize_logger(model_name, dataset_name, temperature, top_p, cot_reasoning, log_dir)
        elif specific_name:
            _initialize_logger(model_name, dataset_name, temperature, top_p, cot_reasoning, log_dir, specific_name)
        else:
            raise ValueError("Logger initialization requires model_name, dataset_name, temperature, top_p, and log_dir.")
    
    return _logger