from common import *

def build_prompt(
    question: str,
    include_cot: bool = True,
    question_type: str = "common",
    answer_type: str = "common",
) -> dict:
    def _build_question() -> str:
        if question_type == "common":
            q_prompt = QUESTION_COMMON_PROMPT_TEMPLATE
        q_prompt += f"\nQuestion: {question}"
        
        if include_cot:
            q_prompt += f"\n{COT_PROMPT_TEMPLATE}"

        return q_prompt

    def _build_answer() -> str:
        a_prompt = f"{ANSWER_FORMAT_PROMPT_TEMPLATE}\n{ANSWER_PROMPT_REASONING_TEMPLATE}\n" \
                    if include_cot else f"{ANSWER_FORMAT_PROMPT_TEMPLATE}\n" 
        if answer_type == "common":
            a_prompt += ANSWER_PROMPT_COMMON_TEMPLATE
        elif answer_type == "math":
            a_prompt += ANSWER_PROMPT_MATH_TEMPLATE
        elif answer_type == "choice":
            a_prompt += ANSWER_PROMPT_CHOICE_TEMPLATE

        return a_prompt

    return {
        "question_prompt": _build_question(),
        "answer_prompt": _build_answer(),
        "prompt": _build_question() + "\n" + _build_answer(),
    }