def check_empty_result(data: dict) -> bool:
    # Recursively check whether any 'result' key in the data contains an empty dictionary.
    if isinstance(data, dict):
        for key, value in data.items():
            if key == "result" and isinstance(value, dict) and not value:
                return True
            if isinstance(value, dict) and check_empty_result(value):
                return True
            if key == "usage" and value is None:
                return True 
    return False

replace_list = ["\\", "boxed", " ", "{", "}", "text", "(", ")", "$", ",", "（", "）", "，", "。"]
def clean_unwant_string(input_string, replace_list = replace_list):
    for replace_string in replace_list:
        input_string = input_string.replace(replace_string, "")
    return input_string.strip()