import numpy as np

max_indices = None
max_pid = None

with open("input.txt", "r") as fp:
    for line in fp:
        pid = (line.split("pid (")[1].split(")")[0])
        pid = tuple(map(int, pid.split(',')))
        idx = (line.split("idx (")[1].split(")")[0])
        idx = tuple(map(int, idx.split(',')))
        if max_indices is None:
            max_indices = idx
        max_indices = max(idx, max_indices)
        if max_pid is None:
            max_pid = pid
        max_pid = max(pid, max_pid)

shape = tuple(d + 1 for d in max_indices)
pid_shape = tuple(d + 1 for d in max_pid)
arr = np.zeros(pid_shape + shape, dtype=np.uint64)
arr[...] = -3

with open("input.txt", "r") as fp:
    for line in fp:
        pid = (line.split("pid (")[1].split(")")[0])
        pid = tuple(map(int, pid.split(',')))
        idx = (line.split("idx (")[1].split(")")[0])
        idx = tuple(map(int, idx.split(',')))
        value = int(line.split(":")[1])
        arr[pid + idx] = value

print(shape)

np.set_printoptions(threshold=np.inf, linewidth=300, precision=6, suppress=True)
print(arr.astype(np.int64))
