#!/bin/bash

CONFIG_PATH="configs/config_generate.json"
MODEL_NAME="dicmor" # ['imder', 'dicmor']
DATASET_NAME="mosi"
TRAIN_MODE="regression"
NUM_WORKERS=4
DATE=$(date +%Y%m%d_%H%M%S) 
LOG_DIR="logs/${DATE}" 
DATE=$(date +%Y%m%d_%H%M%S) 
SAVE_DIR="results/saved_models/${DATE}"  
NUM_MODAL=2
AVA_MODALITIES=(1 2)
AVA_SIZE=0.5
#(0:text, 1:audio, 2:vision)

mkdir -p $LOG_DIR
mkdir -p $SAVE_DIR

# set up random seeds and train_ratio
SEEDS=(1234 2234 3234)
TRAIN_RATIOS=(0.55)
GPU_ID=4

GENERATION_LOSS_WEIGHT=0.1
CONFLICT_LOSS_WEIGHT=0.01

export CUDA_VISIBLE_DEVICES=${GPU_ID}


LOG_BASE_DIR="${LOG_DIR}/experiments_${DATASET_NAME}_${MODEL_NAME}"
mkdir -p ${LOG_BASE_DIR}

echo "Starting experiments with following configuration:"
echo "Model: ${MODEL_NAME}"
echo "Dataset: ${DATASET_NAME}"
echo "Mode: ${TRAIN_MODE}"
echo "GPU: ${GPU_ID}"
echo "Seeds: ${SEEDS[*]}"
echo "Train ratios: ${TRAIN_RATIOS[*]}"
echo "Available modalities: ${AVA_MODALITIES[@]}"
echo "Fix test set to full modal"
echo "Using modality conflict regularization"


for SEED in "${SEEDS[@]}"; do
    for RATIO in "${TRAIN_RATIOS[@]}"; do
        echo "Running experiment with seed ${SEED}, train_ratio ${RATIO} on GPU ${GPU_ID}"
        
        
        LOG_FILE="${LOG_BASE_DIR}/avamodal_${AVA_MODALITIES[@]}_seed${SEED}_ratio${RATIO}.log"
        
        
        python train.py \
            --config_path "${CONFIG_PATH}" \
            --model_name "${MODEL_NAME}" \
            --dataset_name "${DATASET_NAME}" \
            --train_mode "${TRAIN_MODE}" \
            --num_workers "${NUM_WORKERS}" \
            --cur_seed "${SEED}" \
            --train_ratio "${RATIO}" \
            --log_dir "${LOG_DIR}" \
            --save_dir "${SAVE_DIR}" \
            --device cuda \
            --generate \
            --cross_modal_generation_loss_weight ${GENERATION_LOSS_WEIGHT} \
            --num_modal "${NUM_MODAL}" \
            --ava_modal_idx ${AVA_MODALITIES[@]} \
            --use_modal_conflict \
            --modality_conflict_loss_weight ${CONFLICT_LOSS_WEIGHT} \
            --available_size ${AVA_SIZE} \
            > "${LOG_FILE}" 2>&1
        
        echo "Completed experiment: seed=${SEED}, ratio=${RATIO}"
        echo "Log file: ${LOG_FILE}"
    done
done