# Copyright 2020-present, Pietro Buzzega, Matteo Boschini, Angelo Porrello, Davide Abati, Simone Calderara.
# All rights reserved.
# This source code is licensed under the license found in the
# LICENSE file in the root directory of this source tree.

import numpy as np
import torchvision.transforms as transforms
from torch.utils.data import Dataset,DataLoader
#from backbone.ResNet18 import resnet18
import torch.nn.functional as F
from conf import base_path,ContinualDataset
from PIL import Image
import os
import os
import sys
from torch.utils.data import Dataset, DataLoader
import numpy as np
import cv2
from torchvision import transforms
#from datasets.utils.validation import get_train_val
#from datasets.utils.continual_dataset import ContinualDataset, store_masked_loaders
#from datasets.utils.continual_dataset import get_previous_train_loader
#from datasets.transforms.denormalization import DeNormalize

class Imagenet(Dataset):
    """
    Defines Tiny Imagenet as for the others pytorch datasets.
    """
    def __init__(self, root: str, train: bool=True, transform: transforms=None,
                target_transform: transforms=None, download: bool=False) -> None:
        self.not_aug_transform = transforms.Compose([transforms.ToTensor()])
        self.root = root
        self.train = train
        self.transform = transform
        self.target_transform = target_transform
        self.download = download
        root_train='/home/guoyd/Imagenet32_train_npz'
        root_val = '/home/guoyd/Imagenet32_val_npz'

        if download:
           # print(root)
            if os.path.isdir(root) and len(os.listdir(root)) > 0:
                print('Download not needed, files already on disk.')
            else:
                from google_drive_downloader import GoogleDriveDownloader as gdd

                # https://drive.google.com/file/d/1Sy3ScMBr0F4se8VZ6TAwDYF-nNGAAdxj/view
                print('Downloading dataset')
                gdd.download_file_from_google_drive(
                    file_id='1Sy3ScMBr0F4se8VZ6TAwDYF-nNGAAdxj',

                    dest_path=os.path.join(root, 'tiny-imagenet-processed.zip'),
                    unzip=True)

        self.data = []
        self.targets = []
       # train_data_batch_2.npz
        if self.train:
            for num in range(10):
                self.data.append(np.load(os.path.join(root_train,'%s_data_batch_%d.npz'%('train' if self.train else 'val', num + 1)))['data'])

                self.targets.append(np.load(os.path.join(
                    root_train, '%s_data_batch_%d.npz' %
                          ('train' if self.train else 'val', num + 1)))['labels'])
        else:
            self.data.append(np.load(os.path.join(
                root_val, 'val_data.npz'))['data'])
            self.targets.append(np.load(os.path.join(
                root_val, 'val_data.npz'))['labels'])

        self.data = np.concatenate(np.array(self.data))

        self.targets = np.concatenate(np.array(self.targets))

    def __len__(self):
        return len(self.data)

    def __getitem__(self, index):
        img, target = self.data[index], self.targets[index]-1


        # doing this so that it is consistent with all other datasets
        # to return a PIL Image
        img = Image.fromarray(np.uint8(255 * img))
        original_img = img.copy()

        if self.transform is not None:
            img = self.transform(img)

        if self.target_transform is not None:
            target = self.target_transform(target)

        if hasattr(self, 'logits'):
            return img, target, original_img, self.logits[index]

        return img, target


class MyImagenet(Imagenet):
    """
    Defines Tiny Imagenet as for the others pytorch datasets.
    """
    def __init__(self, root: str, train: bool=True, transform: transforms=None,
                target_transform: transforms=None, download: bool=False) -> None:
        super(MyImagenet, self).__init__(
            root, train, transform, target_transform, download)

    def __getitem__(self, index):
        import torch
        import pdb

        #img, target = (torch.tensor(self.data[index]).reshape(32,32,3)).numpy(), self.targets[index]-1

        #pdb.set_trace()
        img, target=(torch.tensor(self.data[index]).reshape(3,32,32)*1.0/255), self.targets[index]-1#(torch.tensor(self.data[index]).reshape(3,32,32)).numpy()
        import torchvision.transforms.functional as FF
        img=FF.normalize(img,[0.4810827450980392, 0.457478431372549, 0.4078611764705882] ,[0.229, 0.224, 0.225],False)
                        # , [122.6761, 116.6570, 104.0046], [52.2893, 51.2616, 51.5630], False)

        # doing this so that it is consistent with all other datasets
        # to return a PIL Imageimg

       # (x * 255).astype(np.uint8)
       # import pdb

       # img = Image.fromarray(np.uint8(img))
       # original_img = img.copy()


        not_aug_img = img#original_img#self.not_aug_transform(original_img)
       # pdb.set_trace()

        if self.transform is not None:
            img = img#self.transform(img)
            #img=self.transform(torch.tensor(img/255)*1.0)

        if self.target_transform is not None:
            target = self.target_transform(target)
        #pdb.set_trace()

        return img, target
class TinyImagenet(Dataset):
    """
    Defines Tiny Imagenet as for the others pytorch datasets.
    """
    def __init__(self, root: str, train: bool=True, transform: transforms=None,
                target_transform: transforms=None, download: bool=False) -> None:
        self.not_aug_transform = transforms.Compose([transforms.ToTensor()])
        self.root = root
        self.train = train
        self.transform = transform
        self.target_transform = target_transform
        self.download = download
        root='/home/guoyd/Dataset/con/CF2/OCMM/data/TINYIMG'

        if download:
           # print(root)
            if os.path.isdir(root) and len(os.listdir(root)) > 0:
                print('Download not needed, files already on disk.')
            else:
                from google_drive_downloader import GoogleDriveDownloader as gdd

                # https://drive.google.com/file/d/1Sy3ScMBr0F4se8VZ6TAwDYF-nNGAAdxj/view
                print('Downloading dataset')
                gdd.download_file_from_google_drive(
                    file_id='1Sy3ScMBr0F4se8VZ6TAwDYF-nNGAAdxj',

                    dest_path=os.path.join(root, 'tiny-imagenet-processed.zip'),
                    unzip=True)

        self.data = []
        for num in range(20):
            self.data.append(np.load(os.path.join(
                root, 'processed/x_%s_%02d.npy' %
                      ('train' if self.train else 'val', num+1))))
        self.data = np.concatenate(np.array(self.data))

        self.targets = []
        for num in range(20):
            self.targets.append(np.load(os.path.join(
                root, 'processed/y_%s_%02d.npy' %
                      ('train' if self.train else 'val', num+1))))
        self.targets = np.concatenate(np.array(self.targets))

    def __len__(self):
        return len(self.data)

    def __getitem__(self, index):
        img, target = self.data[index], self.targets[index]

        # doing this so that it is consistent with all other datasets
        # to return a PIL Image
        img = Image.fromarray(np.uint8(255 * img))
        original_img = img.copy()

        if self.transform is not None:
            img = self.transform(img)

        if self.target_transform is not None:
            target = self.target_transform(target)

        if hasattr(self, 'logits'):
            return img, target, original_img, self.logits[index]

        return img, target


class MyTinyImagenet(TinyImagenet):
    """
    Defines Tiny Imagenet as for the others pytorch datasets.
    """
    def __init__(self, root: str, train: bool=True, transform: transforms=None,
                target_transform: transforms=None, download: bool=False) -> None:
        super(MyTinyImagenet, self).__init__(
            root, train, transform, target_transform, download)

    def __getitem__(self, index):
        img, target = self.data[index], self.targets[index]

        # doing this so that it is consistent with all other datasets
        # to return a PIL Image
        img = Image.fromarray(np.uint8(255 * img))
        original_img = img.copy()

        not_aug_img = self.not_aug_transform(original_img)

        if self.transform is not None:
            img = self.transform(img)

        if self.target_transform is not None:
            target = self.target_transform(target)

        return img, target


class SequentialTinyImagenet(ContinualDataset):

    NAME = 'seq-tinyimg'
    SETTING = 'class-il'
    N_CLASSES_PER_TASK = 200
    N_TASKS = 1
    TRANSFORM = transforms.Compose(
            [transforms.RandomCrop(64, padding=4),
             transforms.RandomHorizontalFlip(),
             transforms.ToTensor(),
             transforms.Normalize((0.4802, 0.4480, 0.3975),
                                  (0.2770, 0.2691, 0.2821))])

    def get_data_loaders(self):
        #transform = self.TRANSFORM
        transform = transforms.Normalize((0.4802, 0.4480, 0.3975),
                                         (0.2770, 0.2691, 0.2821))

        test_transform = transforms.Compose(
            [transforms.ToTensor(), transform])

        train_dataset = MyTinyImagenet(base_path() + 'TINYIMG',
                                 train=True, download=True, transform=test_transform)
        #if self.args.validation:
         #   train_dataset, test_dataset = get_train_val(train_dataset,
         #                                           test_transform, self.NAME)
        #else:
        test_dataset = TinyImagenet(base_path() + 'TINYIMG',
                        train=False, download=True, transform=test_transform)

        #train, test = store_masked_loaders(train_dataset, test_dataset, self)
        return DataLoader(train_dataset, batch_size=64, shuffle=True),DataLoader(test_dataset, batch_size=64, shuffle=True)#train_dataset, test_dataset

    #def not_aug_dataloader(self, batch_size):
     #   transform = transforms.Compose([transforms.ToTensor(), self.get_denormalization_transform()])

      #  train_dataset = MyTinyImagenet(base_path() + 'TINYIMG',
                            #train=True, download=True, transform=transform)
       # train_loader = get_previous_train_loader(train_dataset, batch_size, self)

        #return train_loader


    @staticmethod
    #def get_backbone():
     #   return resnet18(SequentialTinyImagenet.N_CLASSES_PER_TASK
      #                  * SequentialTinyImagenet.N_TASKS)

    @staticmethod

    def get_loss():
        return F.cross_entropy

    def get_transform(self):
        transform = transforms.Compose(
            [transforms.ToPILImage(), self.TRANSFORM])
        return transform

    @staticmethod
    def get_normalization_transform():
        transform = transforms.Normalize((0.4802, 0.4480, 0.3975),
                                         (0.2770, 0.2691, 0.2821))
        return transform

    #@staticmethod
    #def get_denormalization_transform():
     #   transform = DeNormalize((0.4802, 0.4480, 0.3975),
     #                                    (0.2770, 0.2691, 0.2821))
      #  return transform