import os
import pickle
import datetime
from typing import Any, Optional
from torch.utils.tensorboard import SummaryWriter

try:
    import wandb
    WANDB_AVAILABLE = True
except ImportError:
    WANDB_AVAILABLE = False

base_path = '/cfs/hadoop-aipnlp'
if not os.path.exists(base_path):
    base_path = '/mnt/anonymous/' 
ckpt_path = os.path.join(base_path, 'anonymous/logs')
writer: Optional[SummaryWriter] = None
project_name = ''
pickle_dict = {'Config': {}}


def init(project, name):
    time = datetime.datetime.now().strftime('%Y%m%d%H%M%S')
    global writer, project_name
    writer = SummaryWriter(log_dir=f'{ckpt_path}/{project}/{name}_{time}')
    if WANDB_AVAILABLE:
        wandb.init(project=project, name=name, mode="offline")
    project_name = f'{project}_{name}_{time}'


def log(key_value_list, step):
    for key, value in key_value_list.items():
        if '/' in key:
            writer.add_scalar(key, value, step)
        else:
            writer.add_scalar(f"Charts/{key}", value, step)
    pickle_dict[step] = key_value_list
    if WANDB_AVAILABLE:
       wandb.log(key_value_list, step)


def finish():
    pickle.dump(pickle_dict, open(f"{ckpt_path}/{project_name}.pkl", "wb"))
    writer.close()
    if WANDB_AVAILABLE:
       wandb.finish()


class Config:
    def __setattr__(self, __name: str, __value: Any) -> None:
        # writer.add_text(__name, str(__value))
        # weired bug for tensorboardx writer, just ignore it.
        pickle_dict['Config'][__name] = __value
        if WANDB_AVAILABLE:
           wandb.config.__setattr__(__name, __value)


config = Config()