## Wasserstein Fair AutoEncoders

### How to run   
First, you can easily create an environment that meets the requirements if you're using anaconda. Otherwise, you can install the requirements using `pip`.  

```bash
conda env create -f environment.yaml
```   

The configuration of the codes are managed by `hydra` module, and all models, logs, tensorboard logs are generated in `./outputs` directory.

Before you run the main code, you need to pretrain classifier for each dataset by:

```bash
python pretrain_MNIST.py
python pretrain_eYaleB.py
```

For Extended Yale B dataset, you need to download raw file from url and preprocess it with Preprocess_EYaleB.ipynb. MNIST is automatically downloaded. 

Next, move the checkpoint file generated to this home folder with the name 'pretrain_MNIST.ckpt', 'pretrain_eYaleB.ckpt', respectively. Then, you can run the main code:

```bash
python main.py train_info=WFAE_MNIST
python main.py train_info=WFAE_eYaleB
```

You can change the hyperparameters by adjusting yaml files in`configs/train_info` 

### Citation   
```
@Misc{Yadan2019Hydra,
  author =       {Omry Yadan},
  title =        {Hydra - A framework for elegantly configuring complex applications},
  howpublished = {Github},
  year =         {2019},
  url =          {https://github.com/facebookresearch/hydra}
}
```   
