source $CONDA_SH
source shell/4_evaluation/__evaluation_func.sh

export INTERNVL4="finetuning_results/internvl_finetuning_log/InternVL2-4B_3d__angle_20241106_203320 finetuning_results/internvl_finetuning_log/InternVL2-4B_3d__size_20241106_193554 finetuning_results/internvl_finetuning_log/InternVL2-4B_syntheticgeometry__angle_20241106_232458 finetuning_results/internvl_finetuning_log/InternVL2-4B_syntheticgeometry__area_20241107_002108 finetuning_results/internvl_finetuning_log/InternVL2-4B_syntheticgeometry__length_20241107_011728 finetuning_results/internvl_finetuning_log/InternVL2-4B_syntheticgeometry__quadrilateral_20241106_222740 finetuning_results/internvl_finetuning_log/InternVL2-4B_syntheticgeometry__triangle_20241106_213204"
export INTERNVL8="finetuning_results/internvl_finetuning_log/InternVL2-8B_3d__angle_20241106_182532 finetuning_results/internvl_finetuning_log/InternVL2-8B_3d__size_20241106_165308 finetuning_results/internvl_finetuning_log/InternVL2-8B_syntheticgeometry__angle_20241106_230117 finetuning_results/internvl_finetuning_log/InternVL2-8B_syntheticgeometry__area_20241107_003601 finetuning_results/internvl_finetuning_log/InternVL2-8B_syntheticgeometry__length_20241107_020956 finetuning_results/internvl_finetuning_log/InternVL2-8B_syntheticgeometry__quadrilateral_20241106_213050 finetuning_results/internvl_finetuning_log/InternVL2-8B_syntheticgeometry__triangle_20241106_200045"
export PHI="finetuning_results/phi35v_finetuning_log/Phi-3.5-vision-instruct_3d__angle_2024-11-05_16-51-11 finetuning_results/phi35v_finetuning_log/Phi-3.5-vision-instruct_3d__size_2024-11-05_16-02-56 finetuning_results/phi35v_finetuning_log/Phi-3.5-vision-instruct_syntheticgeometry__angle_2024-11-05_14-58-51 finetuning_results/phi35v_finetuning_log/Phi-3.5-vision-instruct_syntheticgeometry__area_2024-11-05_13-55-38  finetuning_results/phi35v_finetuning_log/Phi-3.5-vision-instruct_syntheticgeometry__length_2024-11-05_12-53-35 finetuning_results/phi35v_finetuning_log/Phi-3.5-vision-instruct_syntheticgeometry__quadrilateral_2024-11-05_11-50-56 finetuning_results/phi35v_finetuning_log/Phi-3.5-vision-instruct_syntheticgeometry__triangle_2024-11-05_10-47-55"

for MODELS_LIST in $INTERNVL4 $INTERNVL8 $PHI
do
    for MODEL in $MODELS_LIST
    do
        activate_conda_env $MODEL

        for PROMPT in no_reasoning
        do
            # echo "Evaluating on Training Data"
            # python src/evaluation/evaluation.py --model $MODEL --prompt $PROMPT --data train

            echo "Evaluating model $MODEL with prompt $PROMPT on Real Eval Data"
            python src/evaluation/evaluation.py --model $MODEL --prompt $PROMPT --data eval_real

            echo "Evaluating model $MODEL with prompt $PROMPT on Synthetic Eval Data"
            python src/evaluation/evaluation.py --model $MODEL --prompt $PROMPT --data eval_synthetic
        done

        conda deactivate
    done
done

python src/evaluation/generate_tables_finetuned.py
