from src.path import vlmevalkit_models_list_path


def get_vlmeval_models_list() -> list[str]:
    output_list: list[str] = []
    with open(vlmevalkit_models_list_path, "r") as f:
        for line in f:
            output_list.append(line.strip())
    
    return output_list


def is_vlmeval_models(model_name: str) -> bool:
    # we use model specific code for these models
    ignore_list = ["InternVL", "Phi-3.5"]
    for ignore_name in ignore_list:
        if ignore_name in model_name:
            return False
    
    # for other models, check if they are in the VLMEvalKit models list
    return model_name in get_vlmeval_models_list()
