## Preprocess
CIFAR-10,CIFAR-100 and CIFAR-100H can be downloaded automatically during program operation. Put the files into ./dataset/CIFAR10 and ./dataset/CIFAR100

For CUB200, PiCO provides a preprocessed copy at https://drive.google.com/file/d/1KNMPuKT1q3a6zIEgStar2o4xjs_a3Kge/view?usp=sharing and just put the files to dataset/CUB200/processed. See https://github.com/hbzju/PiCO for detail.

## ALIM
We provide the following shell codes for model training. Adjusting the learning rate, epochs, weight_decay and the time to start applying Alim may achieve better results. 

### For Tabel 1: 
```
1.Run CIFAR10 with q=0.3 \eta=0.3:
nohup python -u train_merge.py --seed=1 --save_root=savefinals --dataset=cifar10 --dataset_root=./dataset/CIFAR10 --partial_rate=0.3 --noise_rate=0.3 --epochs=1000 --encoder=resnet --lr=0.01 --lr_adjust=Case1 --optimizer=sgd --weight_decay=1e-3 --gpu=0 --piror_start 80 --max1 > cifar10q03n03start80.out 2>&1 &

2.Run CIFAR100 with q=0.05 \eta=0.3:
nohup python -u train_merge.py --seed=1 --save_root=savefinals --dataset=cifar100 --dataset_root=./dataset/CIFAR100 --partial_rate=0.05 --noise_rate=0.3 --epochs=1000 --encoder=resnet --lr=0.01 --lr_adjust=Case1 --optimizer=sgd --weight_decay=1e-3 --gpu=0 --piror_start 80 --max1 > cifar100q005n03start80.out 2>&1 &

3.Run CIFAR100 with q=0.05 \eta=0.3 without MIXUP:
nohup python -u train_merge.py --seed=1 --save_root=savefinals --dataset=cifar100 --dataset_root=./dataset/CIFAR100 --partial_rate=0.05 --noise_rate=0.3 --epochs=1000 --encoder=resnet --lr=0.01 --lr_adjust=Case1 --optimizer=sgd --weight_decay=1e-3 --gpu=0 --piror_start 80 --loss_weight_mixup 0 --max1 > cifar100q005n03start80nomixup.out 2>&1 &

4.Run CIFAR100 with q=0.05 \eta=0.3 with SCALE NORMALIZATION:
nohup python -u train_merge.py --seed=1 --save_root=savefinals --dataset=cifar100 --dataset_root=./dataset/CIFAR100 --partial_rate=0.05 --noise_rate=0.3 --epochs=1000 --encoder=resnet --lr=0.01 --lr_adjust=Case1 --optimizer=sgd --weight_decay=1e-3 --gpu=0 --piror_start 80 --proto_case=Case3 --max1 > cifar100q005n03start80scale.out 2>&1 &

5.More examples refer to example.sh
```

### For Tabel 2:
For compatibility experiments with RC, please cd ./RC.
```
1.origin:
nohup python main.py --dataset='cifar10' --dataset_root='../dataset/CIFAR10' --gpu=0 --lr=0.01 --lr_adjust='case2' --noise_rate=0.3 --partial_rate=0.5 --seed=0 --weight_decay=0.001 --conf_ema_m 0.9 --epochs 200 --batch_size 128 > rccifar10q03n05seed0.out &

2.equip rc with Alim:
nohup python main.py --dataset='cifar10' --dataset_root='../dataset/CIFAR10' --gpu=0 --lr=0.01 --lr_adjust='case2' --noise_rate=0.3 --partial_rate=0.5 --piror_start=20 --seed=0 --weight_decay=0.001 --conf_ema_m 0.9 --epochs 200 --batch_size 128 > Alimrccifar10q03n05seed0.out &
```

For compatibility experiments with CRDPLL, please cd ./CRDPLL.
```
1.origin:
nohup python main.py --data-dir ../dataset/CIFAR100 --dataset cifar100 --gpu 0 --lr 0.1 --model resnet18 --noise_rate 0.3 --rate 0.05 --seed 0 --epochs 300 > crdpllcifar100q005n03seed0.out &

2.equip rc with Alim:
nohup python main.py --data-dir ../dataset/CIFAR100 --dataset cifar100 --gpu 0 --lr 0.1 --model resnet18 --noise_rate 0.3 --rate 0.05 --seed 0 --piror_start 80 --epochs 300 > Alimcrdpllcifar100q005n03seed0.out &
```

### For Tabel 3: 
```
1.Run CUB200 with q=0.05 \eta=0.2:
nohup python -u train_merge.py --seed=1 --save_root=savefinals --dataset=cub200 --dataset_root=./dataset/CUB200 --partial_rate=0.05 --noise_rate=0.2 --epochs=200 --encoder=resnet --lr=0.01 --lr_adjust=Case1 --optimizer=sgd --weight_decay=1e-5 --gpu=0 --proto_start 30 --batch_size=256 --moco_queue=4096 --piror_start 60 --max1 > cub200q005n02start60.out 2>&1 &

2.Run CIFAR100H with q=0.5 \eta=0.2:
nohup python -u train_merge.py --seed=1 --save_root=savefinals --dataset=cifar100H --dataset_root=./dataset/CIFAR100 --partial_rate=0.5 --noise_rate=0.2 --epochs=1000 --encoder=resnet --lr=0.01 --lr_adjust=Case1 --optimizer=sgd --weight_decay=1e-3 --gpu=0 --piror_start 80 --max1 > cifar100Hq05n02start80.out 2>&1 &
```

### For Figure 2 and Figure 3: 
```
1.Run CIFAR100 with q=0.05 \eta=0.3 with fix \lambda=0.4:
nohup python -u train_merge.py --seed=1 --save_root=savefinals --dataset=cifar100 --dataset_root=./dataset/CIFAR100 --partial_rate=0.05 --noise_rate=0.3 --epochs=1000 --encoder=resnet --lr=0.01 --lr_adjust=Case1 --optimizer=sgd --weight_decay=1e-3 --gpu=0 --piror_start 80 --piror_auto='case3' --piror_add=0.4 --piror_max=0.4 --max1 > cifar100q005n03start80fix04.out 2>&1 &

2.Run with different e_{start}/\lambda_{mix}, please adjust hyper-parameters piror_start/loss_weight_mixup.
```