import os
import sys
import platform
import random

from overcooked_ai_py.mdp.overcooked_mdp import OvercookedGridworld, OvercookedState, ObjectState, SoupState
# from shared_utils import get_feasible_stat
from models.shared_utils import get_feasible_stat, VAR_COUNTER, VAR_POT


def random_twist_start_state(mdp: OvercookedGridworld, start_state: OvercookedState, chosen_pos):
    twisted_state = start_state.deepcopy()

    if isinstance(chosen_pos, tuple):
        chosen_pos = [chosen_pos]
    for pos in chosen_pos:
        pos_type = mdp.get_terrain_type_at_pos(pos)
        if pos_type == 'X':
            obj_type = random.choice(VAR_COUNTER)
            obj = ObjectState(obj_type, pos)
            twisted_state.add_object(obj)
        elif pos_type == 'P':
            onion_num = random.choice(VAR_POT)
            soup_obj = SoupState(pos, ingredients=[ObjectState('onion', pos) for i in range(onion_num)])
            twisted_state.add_object(soup_obj)

    return twisted_state


def random_gen_start_state_fn_v0(mdp: OvercookedGridworld, epi=1, reachable_only=True, top_k=1, verbose=True, *args, **kwargs):
    standard_start_state = mdp.get_standard_start_state()
    stat_dict = get_feasible_stat(mdp)

    empty_counter_pos = stat_dict['all_reachable_counter'] if reachable_only else mdp.get_counter_locations()
    all_pots = mdp.get_pot_locations()

    all_manipulable_pos = empty_counter_pos + all_pots

    choices = [random.sample(all_manipulable_pos, epi) for _ in range(top_k)]
    if verbose:
        print(choices)

    # for choice in choices:
    #     twisted_state = random_twist_start_state(mdp, standard_start_state, choice)
    #     print(twisted_state.objects)
    #     start_fn_list.append(lambda: twisted_state.deepcopy())
    #     # Wrong! See lambda and Closure

    twisted_states = [random_twist_start_state(mdp, standard_start_state, choice) for choice in choices]

    return twisted_states
