## Requirements

To install requirements:

```setup
conda install pytorch==1.13.1 pytorch-cuda=11.6 -c pytorch -c nvidia
pip install -r requirements.txt
```

The python version is 3.7.11

To install gym, you may need to downgrade wheel and setuptools.

We use some public repositories with customization, including Overcooked-ai 1.1.0, human-aware-rl 0.0.1. The modified code are in the "third_party_libs" folder.

Some requirements may not be necessary for the current version of code.

## Training
**This code contains a minimum set for reproducing the core result, high quality code will be published in the future.** 

To train a demo model to reproduce the results, run the following commands:

```train
# First train an agent
cd train_agent/ppo
python sp.py with layout_name=coordination_ring verbose=1 exp_name=reproduce

# attack
cd ../../robust_test
python main_v2.py --attack_method no_target -a reproduce --agent_path_root ../train_agent/saved_models/sp -l coordination_ring --horizon 800 --eval_n 100 --attack_n 20 -p 40 --epi 3 -k 10 --exp_id reproduce --result_root .

python main_v2.py --attack_method gt -a reproduce --agent_path_root ../train_agent/saved_models/sp -l coordination_ring --horizon 800 --eval_n 100 --attack_n 20 -p 40 --epi 3 -k 40 --exp_id reproduce --result_root .

python main_v2.py --attack_method random -a reproduce --agent_path_root ../train_agent/saved_models/sp -l coordination_ring --horizon 800 --eval_n 100 --attack_n 20 -p 40 --epi 3 -k 40 --exp_id reproduce --result_root .

# defense
python send_finetune_tasks_v2.py -a reproduce --eval_n 100 --attack_n 20 -f reproduce --methods random no_target --ks 40 10 --send_ns 5 5 --exp_ids reproduce reproduce

python kd_agent.py --agent_path ../train_agent/saved_models/sp/coordination_ring/reproduce --agent_name reproduce -l coordination_ring --st_fn reproduce.pkl --exp_id reproduce --verbose False -T 1 --slack_T 1.5 --v_slack 0.05 --n_epoch 100 --lr 1e-3 --device cuda --batch_size 8000 --data_n 20 --horizon 800

cd ../train_agent/ppo
python sp_rob_finetune.py with layout_name=coordination_ring verbose=1 exp_name=reproduce from_pretrained=True pretrained_path=../saved_models/sp/coordination_ring/reproduce/kd/reproduce.pt device=cuda start_state_path=../saved_models/sp/coordination_ring/reproduce/start_states/reproduce.pkl total_timesteps=8e6 vf_coef=0.01 tb_log_name=reproduce standard_rate=0.3

```
