base_path=your_trained_model_path
model_name=your_model_name
system_prompt=None
seeds=(42)
for ckpt in {50..800..50}
do
    model_name_or_path="${base_path}/checkpoint-${ckpt}"
    for seed in "${seeds[@]}"
    do
        for index in {0..7}
        do
            echo "Processing seed-${seed}, model_name-${model_name}, checkpoint-${ckpt}, partition ${index}"
            input_source="./datasets/AIME2025/aime2025_reformatted_p${index}.json" 
            echo "input_source-${input_source}"
            cuda=${index}
            pseudo_master_port=2950${index}
            suffix=ckpt-${ckpt}/p${index}
            
            nohup bash scripts/generate_lora.sh model_name=${model_name} base_model="DeepSeek-R1-Distill-Qwen-1.5B" \
                model_name_or_path=${model_name_or_path} load_in_8bit=False input_source=${input_source} merge_lora=True torch_dtype=bfloat16 \
                prompt_templates=simple_chat system_prompt=${system_prompt} max_new_tokens=8192 do_sample=True num_beams=1 temperature=0.6 \
                top_p=0.95 top_k=60000 length_penalty=1.0 renormalize_logits=True num_return_sequences=8 save_steps=1 eval_batch_size=64 seed=${seed} \
                role_tags="{'user':'<｜User｜>','assistant':'<｜Assistant｜>'}" \
                use_cache=True cuda=${cuda} pseudo_master_port=${pseudo_master_port} prefix=AIME-25 suffix=${suffix} &
            sleep 13
        done
        wait
    done
done
