# Agentic IQA - ReadMe

This document provides instructions on how to run the Agentic IQA system using the `main.py` script. The system integrates GPT-4o and Qwen2.5-VL for intelligent question answering.

## Prerequisites

1. **Python Environment**: Ensure you have Python 3.8 or higher installed.
2. **Dependencies**: Install the required Python libraries. Run the following command:
    ```
    conda env create -f environment.yml
    ```
3. **API Keys**: Ensure you have valid API keys for GPT-4o and Qwen2.5-VL. Set them as environment variables:
    ```
    export GPT4O_API_KEY=your_gpt4o_api_key
    ```

## Running the System

1. **Navigate to the Project Directory**:
    ```
    cd AgenticIQA (GPT-4o)
    ```
    or
    ```
    cd AgenticIQA (Qwen2.5-VL)
    ```

2. **Run the Main Script**:
    Execute the `main.py` script to start the Agentic IQA system:
    ```
    python main.py
    ```

3. **Input Questions**:
    Follow the on-screen prompts to input your questions. The system will process the input using GPT-4o and Qwen2.5-VL and provide intelligent answers.

## Notes

- Ensure your internet connection is stable for API calls.
- If you encounter any issues, check the logs for error messages or contact the project maintainer.
