import argparse
import os


def knn():
    args = argparse.Namespace()

    args.dataset = 'cifar100'
    args.arch = ''
    args.pretrained_weights = None
    args.output_dir = './out'
    args.seed = 0

    if args.dataset == 'cifar100' or args.dataset == 'cifar10':
        args.num_workers = 12
        args.prefetch_factor = 2
        args.pin_memory = True
        args.patch_size = 2
        args.input_size = 32
        args.data_root = f'/dataset/{args.dataset}'
        args.batch_size_per_gpu = 256
    
    args.encoder = 'base_encoder'
    args.nb_knn = [10, 20, 100, 200]
    args.temperature = 0.07
    args.use_cuda = True
    args.dump_features = None
    args.load_features = None

    # ----------------#
    args.dist_url = 'tcp://localhost:12635'
    args.dist_backend = 'nccl'
    args.ngpus_per_node = 1
    args.rank = 0
    os.environ["CUDA_VISIBLE_DEVICES"] = '0'
    args.world_size = 1

    args.print_freq = 100
    args.save_freq = 100


    args.exclude_file_list = ['__pycache__', '.vscode',
                              'log', 'ckpt', '.git', 'out', 'dataset', 'weight']

    return args
