import argparse
import os

def vit_base_linear():
    args = argparse.Namespace()

    args.dataset = 'cifar100'
    args.arch = 'vit-base'
    args.resume=None
    args.pretrained_weights = './weight/pretrain/tiny_1600ep_1e-3_100_0.15.pth'
    args.evaluate = None
    args.epochs = 100
    args.start_epoch = 0
    args.output_dir = './out'
    args.seed = 0

    if args.dataset == 'cifar10' or args.dataset == 'cifar100':
        args.num_workers = 4
        args.prefetch_factor = 2
        args.pin_memory = True
        args.patch_size = 2
        args.input_size = 32
        args.batch_size = 256
        args.data_root = f'/dataset/{args.dataset}'

    args.encoder = 'base_encoder'  # [base_encoder,momentum_encoder]
    
    # Optimizer parameters
    args.opt = 'sgd'
    args.opt_eps = 1e-8
    args.opt_betas = None
    args.clip_grad = None
    args.momentum = 0.9

    if args.dataset == 'cifar10':
        args.lr =1.0
        args.weight_decay = 0.0
    elif args.dataset == 'cifar100':
        args.lr = 1.0
        args.weight_decay = 0.0
    
    # ----------------#
    args.dist_url = 'tcp://localhost:12612'
    args.dist_backend = 'nccl'
    args.ngpus_per_node = 1
    args.rank = 0
    os.environ["CUDA_VISIBLE_DEVICES"] = '0'
    args.world_size = 1

    args.print_freq = 100
    args.save_freq = 20

    args.distributed = True

    args.exclude_file_list = ['__pycache__', '.vscode',
                              'log', 'ckpt', '.git', 'out', 'dataset', 'weight']

    return args