from sklearn.metrics import mean_squared_error, log_loss
from sklearn.model_selection import KFold, StratifiedKFold
import numpy as np 
from sklearn.preprocessing import StandardScaler


def CV_eval(model, X, y, task='class', sk=False):
    X, y = np.array(X), np.array(y)
    if task == 'class':
        scorer = log_loss
        cv = StratifiedKFold(5, random_state=45, shuffle=True)
        spl = cv.split(X, y)
    else:
        scorer = mean_squared_error
        cv = KFold(5, random_state=45, shuffle=True)
        spl = cv.split(X)
    
    results = []
    
    for train_index, test_index in spl:
        X_train, X_test = X[train_index], X[test_index]
        y_train, y_test = y[train_index], y[test_index]
        if sk:
          sc = StandardScaler()
          X_train = sc.fit_transform(X_train)
          X_test = sc.transform(X_test)

        model.fit(X_train, y_train)
        if task=='class':
            y_hat = model.predict(X_test)
            print(y_hat)
        else:
            y_hat = model.predict(X_test)
        results.append(scorer(y_test, y_hat))
        print(results)
    return np.mean(results), np.std(results)