# Code for the Paper Stateless Mean-Field Games: A Framework for Independent Learning with Large Populations

This folder contains the relevant code for simulating SMFGs and all experimental results mentioned in the main paper.
The Tor network example code has ben removed in order to preserve anonymity during the double-blind review process, and will be released afterwards.
The code consists of three parts:
- Scripts (located in `scripts/`): contains Python scripts to run the experiments. `run_pb.py` and `run_utd.py` are the basic scripts to run SMFG for a set of parameters from the command line, use the `-h` option to see parameters. The other scripts are for convenience, in order to run many experiments in parallel.
- Notebooks (located in `notebooks/`): contain code for generating plots in the paper, uses the logs generated by scripts.
- Utility files (located in `smfg/`): contains utility implementations of TRPA algorithms and SMFG experiments.

In order to generate all necessary logs for the plots, the files in `scripts/` should be executed once.
Afterwards, the notebooks can be utilized to generate the plots from the log files.
For running the UTD19 experiments, the UTD19 dataset should be downloaded and placed in the `downloads` folder and the `notebooks/modelling_utd19.ipynb` notebook should be executed once.