
import os
from multiprocessing import Pool

import random
import time

# script_template = "python run_pb.py -N {} -K {} -p linear -f full -o ../logs/linear/full -e 20000 --sigma 0.1 -t 0.01"

def run_experiment_bandit(arg):
    time.sleep(0.1 + random.random() * 10)

    command = f"""python run_pb.py --problemseed {arg["problemseed"]} -N {arg["N"]} -K {arg["K"]} -p {arg["problem"]} -f bandit -o {arg["output"]} -e {arg["epochs"]} --epsilon {arg["epsilon"]} --sigma {arg["sigma"]} -t {arg["tau"]} --seed {arg["seed"]}"""
    os.system(command)
    # print(command)
    return

args = []
Ns = [50, 100, 200, 500, 1000]

for seed in range(5):
    output_file = "logs_m/bandit/exp/players/"
    problem = "exp"
    for n in Ns:
        args.append({"N": n, "K": 5, "problemseed": 2,
                     "problem": problem, "output":output_file, "epochs":1000000, "sigma":0.1, "tau":"auto", "epsilon":"auto", "seed":seed})

    output_file = "logs_m/bandit/linear/players/"
    problem = "linear"
    for n in Ns:
        args.append({"N": n, "K": 5, "problemseed": 1,
                        "problem": problem, "output":output_file, "epochs":1000000, "sigma":0.1, "tau":"auto", "epsilon":"auto", "seed":seed})

    output_file = "logs_m/bandit/kl/players/"
    problem = "kl"
    for n in Ns:
        args.append({"N": n, "K": 5, "problemseed": 1,
                        "problem": problem, "output":output_file, "epochs":1000000, "sigma":0.1, "tau":"auto", "epsilon":"auto", "seed":seed})

    output_file = "logs_m/bandit/bb/players/"
    problem = "bb"
    for n in Ns:
        args.append({"N": n, "K": 5, "problemseed": 1, 
                      "problem": problem, "output":output_file, "epochs":1000000, "sigma":0.1, "tau":"auto", "epsilon":"auto", "seed":seed})

with Pool(120) as p:
    p.map(run_experiment_bandit, args)
