
import os
from multiprocessing import Pool

import random
import time

# script_template = "python run_pb.py -N {} -K {} -p linear -f full -o ../logs/linear/full -e 20000 --sigma 0.1 -t 0.01"

def run_experiment_bandit(arg):
    time.sleep(0.1 + random.random() * 10)

    # command = f"""python run_utd.py -N {arg["N"]} --utd_data ../utd_models.pkl -f full -o {arg["output"]} -e {arg["epochs"]} --sigma {arg["sigma"]} -t {arg["tau"]} --seed {arg["seed"]}"""
    command = f"""python run_utd.py -N {arg["N"]} --utd_data ../utd_models.pkl -f bandit -o {arg["output"]} -e {arg["epochs"]} --epsilon {arg["epsilon"]} --sigma {arg["sigma"]} -t {arg["tau"]} --seed {arg["seed"]}"""
    os.system(command)
    # print(command)
    return

args = []
Ns = [50, 100, 200, 500, 1000]

for seed in range(5):
    output_file = "logs_m/bandit/utd/players/"
    for n in Ns:
        args.append({"N": n, "output":output_file, "epochs":1000000,  "epsilon":"auto", "sigma":0.1, "tau":"auto", "seed":seed})


with Pool(50) as p:
    p.map(run_experiment_bandit, args)
