The `./src/` directory contains the python code for running the following three experiments: 
1. Generating Null distributions of cMMD and kernel-MMD statistics (`Expt_NullDists.py`)
2. Generating power curves for the different MMD two-sample tests (`Expt_PowerCurves.py`)
3. Generating ROC curves for the different statistics (`Expt_ROCcurves.py`)


Prerequisites:
* The code dependencies are in the `./requirements.txt` file. 
* For saving the figures, we assume that there exists a directory `./data/`


## Generating Null Distribution plots
The Null distributions of the c-MMD and kernel-MMD statistics can be generated 
by calling the `Expt_NullDists.py` file, and specifying the following options: 
* `--d_low`: the dimension of the low dimensional observations (default 10)
* `--d_high`: the dimension of the high dimensional observations (default 500)
* `--n`: sample size of X-sample (default 500)
* `--m`: sample size of Y-sample (default 500)
* `--num_trials`: number of repetitions to create the density histogram (default 2000)
* `--kernel_type`: set either to "RBF" (for Gaussian) and "Polynomial"
* `--poly_degree`: degree of polynomial kernel
* `--use_dirichlet`: specify this for using Dirichlet distribution 
* `--save_fig`: use this for saving the figure 
* `--save_data`: use this for saving the data as a .pkl file  

Thus, for generating the two figures in the first column of Figure~5 in Appendix E, use the following: 

```
python3 Expt_NullDists.py --d_low 10 --d_high 500 --n 500 --m 500 --num_trials 2000 --kernel_type "Polynomial" --poly_degree 5 --use_dirichlet --save_fig --save_data 
```

## Generating Power Curves. 
The Power curves for the different tests can be generated by calling the `Expt_PowerCurves.py` file, 
and specifying the following options: 
* `--d`: the dimension of the observation space (default =10)
* `--eps`: the value of epsilon, denoting the perturbation of the mean vectors between the null and alt distributions 
* `--num_pert`: the number of coordinates to perturb by epsilon (default 5). 
                this was denoted by `j` in the paper
* `--n`: sample size of X-sample (default 500)
* `--m`: sample  size of Y-sample (default 500)
* `--alpha`: level of the test (default 0.05)
* `--initial`: the minimum sample sizes used in the experiment (default 20)
* `--num_points`: number of sample-sizes to be used to plot the power curve 
                    obtained by taking equispaced points between initial and n ( or m)
* `--num_perms`: number of permutations for kernel-MMD test (default 200)
* `--num_trials`: number of repetitions to estimate the power (default 400)
* `--kernel_type`: either "RBF" or "Polynomial"
* `--poly_degree`: degree of polynomial kernel (default 2)
* `--bmmd_exp`: the exponent for block size, i.e., block-size = n^{bmmd_exp} (default 0.5)
* `--save_fig`: use this for saving the figure
* `--save_data`: use this for saving the data as a .pkl file 


Thus, for generating the  the first plot of Figure~6 in Appendix E and saving both the figure and data, use the following: 

```
python3 Expt_PowerCurves.py --d 10 --num_pert 5 --eps 0.2 --n 500 --m 500 --num_perms 200 --bmmd_exp 0.5 --num_trials 400 --kernel_type "RBF"  --save_fig --save_data 
```

## Generating ROC curves
The ROC curves can be generated by calling the `Expt_ROCcurves.py` file, and specifying the 
following options: 
* `--d`: the dimension of the observation space (default =10)
* `--eps`: the value of epsilon, denoting the perturbation
            for Gaussian distributions this quantifies the perturbation of means 
            for Dirichlet distributions, this quantifies the perturbation of the parameter '\alpha' 
* `--num_pert`: the number of coordinates to perturb by epsilon (default 5). 
                this was denoted by `j` in the paper
* `--n`: sample size of both X-sample and Y-sample (default 200)
* `--num_trials`: number of repetitions to plot the ROC curve(default 1000)
* `--kernel_type`: either "RBF" or "Polynomial"
* `--poly_degree`: degree of polynomial kernel (default 2)
* `--save_fig`: use this for saving the figure
* `--use_dirichlet`: specify this for using Dirichlet distribution  instead of Gaussian

Thus, for generating the  the first plot of Figure~7 in Appendix E and saving  the figure, use the following: 

```
python3 Expt_ROCCurves.py --d 10 --num_pert 5 --eps 0.4 --n 200 --num_trials 1000 --kernel_type "RBF"  --save_fig --use_dirichlet
```
For generating the  the first plot of Figure~8 in Appendix E and saving  the figure, use the following: 

```
python3 Expt_ROCCurves.py --d 10 --num_pert 5 --eps 0.2 --n 200 --num_trials 1000 --kernel_type "RBF"  --save_fig 
```

##TODO: write about other tests...

