# Implementation of STReason: A Modular Multitask Reasoning Framework Integrating Spatio-temporal Models and LLMs
This repository contains the official code for STReason, a reasoning framework designed for solving complex and compositional spatio-temporal tasks given natural language instructions. STReason leverages the in-context learning ability of large language models (LLMs) to generate modular, interpretable programs, which are then systematically executed to produce both the solution and a detailed rationale. 

## Install Dependencies
```
conda env create -f environment.yaml
conda activate STReason
```

## Data Preparation
The data files are available through the [link](https://anon.to/5yJtfZ) and should be put into the `data/` folder for running the code.

## Benchmark Dataset
The benchmark includes 150 queries across three Spatio-tempotal task types; Analysis, Anomaly Detection and Prediction and Reasoning. Each query is paired with a program and ground truth answer. Sample Dataset : data/STReason_SampleDataset.csv

## Task Execution
Having set up the environment, now you can enter your OpenAI API key in the cell that currently reads <Enter your key here> and run the notebook STtask_exec.ipynb .

## Evaluation
For evaluation of the Program Generator, run the notebook STtask_eval.ipynb .

For evaluation of the overall model the proposed evaluation metrics can be used as follows:
* Factuality Score :evaluation/eval_factuality.ipynb
* Constrant Adherence Score : evaluation/eval_constraint.ipynb
* Coherence Score :evaluation/eval_coherence.ipynb

## Demo Video
[▶️ Watch Demo Video](https://anon.to/T5lL94)

