import random


ST_DATA_EXTRACT_EXAMPLES = [
    """Question: Analyze the trend in the historical traffic speed data for the past 24 hours at location 76542 in the LA region, focusing specifically on weekdays only. The current time is 2017-03-01 01:00:00.The data is recorded at 5-minute intervals. Include the Trend Significance in the analysis.
Program:
DATA0 =LOAD_SPATIOTEMPORAL_DATA(location="76542", time="2017-03-01 01:00:00", feature='traffic speed', region='LA', time_int=5, period=24, unit="hours", constraints="weekdays only")
INPUT_DATA = CREATE_FINAL_INPUT(data0=DATA0, spatial_data="None", temporal_data="None")
FINAL_RESULT = RESULT(var=INPUT_DATA)
""",    
    """Question: Perform a seasonality analysis of the historical air quality data for the past 50 days at location tianjin_aq in the Shenzhen region focusing specifically on weekends only. The current time is 2020-09-05 02:05:00.The data is recorded at 60-minute intervals. Analyze the Daily Seasonality Strength and Weekly Seasonality Strength. 
Program:
DATA0 = LOAD_SPATIOTEMPORAL_DATA(location="tianjin_aq", time="2020-09-05 02:05:00", feature="air quality", region='Shenzhen', time_int=60, period=50, unit = "days", constraints="weekends only")
INPUT_DATA = CREATE_FINAL_INPUT(data0=DATA0, spatial_data="None", temporal_data="None")
FINAL_RESULT = RESULT(var=INPUT_DATA)
""",
    """Question: Analyze the historical traffic speed data for the past 48 hours at location 76542 in the LA region focusing everyday, and detect any unusual traffic events. The current time is 2017-03-01 01:00:00. The data is recorded at 5-minute intervals. Provide spatial reasoning observing anomalies in nearby locations.
Program:
DATA0 = LOAD_SPATIOTEMPORAL_DATA(location="76542", time="2017-03-01 01:00:00", feature="traffic speed", region='LA', time_int=5, period=48, unit="hours", constraints="None")
DATA1 = LOAD_SPATIAL_AUX_DATA(spatial_var="neighbour", location="76542", time="2017-03-01 01:00:00", feature='traffic speed', region='LA', time_int=5, period=48, unit="hours", constraints="None")
INPUT_DATA = CREATE_FINAL_INPUT(data0=DATA0, spatial_data=DATA1, temporal_data="None")
FINAL_RESULT = RESULT(var=INPUT_DATA)
""",
    """Question: Analyze the historical air quality data for the past 21 days at location dongsi_aq in the Beijing region,focusing specifically on weekends only and detect any unusual air quality patterns. The current time is 2017-09-05 02:05:00. The data is recorded at 60-minute intervals. Provide temporal reasoning observing patterns of corresponding weather data.
Program:
DATA0 =LOAD_SPATIOTEMPORAL_DATA(location="dongsi_aq", time="2017-09-05 02:05:00", feature='air quality', region='Beijing', time_int=60, period=21, unit="days", constraints="weekends only")
DATA1 = LOAD_TEMPORAL_AUX_DATA(temp_var="weather", location="dongsi_aq", time="2017-09-05 02:05:00", feature='air quality', region='Beijing', time_int=60, period=21, unit="days", constraints="weekends only")
INPUT_DATA = CREATE_FINAL_INPUT(data0=DATA0, spatial_data="None", temporal_data=DATA1)
FINAL_RESULT = RESULT(var=DATA0)
""",       
    """Question: Analyze the historical air quality data for the past 7 days at location 4007 in the Shenzhen region focusing everyday, and detect any unusual air quality patterns. The current time is 2015-04-06 06:00:00. The data is recorded at 60-minute intervals. Provide temporal reasoning observing patterns of corresponding weather data and spatial reasoning observing anomalies in nearby locations.
Program:
DATA0 = LOAD_SPATIOTEMPORAL_DATA(location="4007", time="2015-04-06 06:00:00", feature='air quality', region='Shenzhen', time_int=60, period=7, unit="days", constraints="None")
DATA1 = LOAD_TEMPORAL_AUX_DATA(temp_var="weather", location="4007", time="2015-04-06 06:00:00", feature = 'air quality', region='Shenzhen', time_int=60, period=7, unit="days", constraints="None")
DATA2 = LOAD_SPATIAL_AUX_DATA(spatial_var="neighbour", location="4007", time="2015-04-06 06:00:00", feature='air quality', region='Shenzhen', time_int=60, period=7, unit="days", constraints="None")
INPUT_DATA = CREATE_FINAL_INPUT(data0=DATA0, spatial_data=DATA2, temporal_data=DATA1)
FINAL_RESULT = RESULT(var=INPUT_DATA)
""",
    """Question: The current time is 2012-03-01 01:00:00. Predict the traffic speed of sensor ID 767542 in the LA region for the next 1 hour using the historical data of the past 1 hour with data points recorded at 5-minute intervals. Ensure the predicted traffic speed does not exceed the 100 km/h safety threshold. Analyze how daily timestamps and neighbouring sensors influence the traffic speed predictions.
Program:
DATA0 = LOAD_SPATIOTEMPORAL_DATA(location="767542", time="2012-03-01 01:00:00", feature="traffic speed", region='LA', time_int=5, period=1, unit = "hours", constraints="None")
DATA1 = LOAD_SPATIAL_AUX_DATA(spatial_var="neighbour", location="767542", time="2012-03-01 01:00:00", feature='traffic speed', region='LA', time_int=5, period=1, unit="hours", constraints="None")
INPUT_DATA = CREATE_FINAL_INPUT(data0=DATA0, spatial_data=DATA1, temporal_data="None")
FINAL_RESULT = RESULT(var=INPUT_DATA)
""",
    """Question: The current time is 2012-03-05 02:05:00. Predict the traffic speed of sensor ID 769806 in the BAY region for the the next 15 minutes using the historical data of the past 1 hour with data points recorded at 5-minute intervals. Ensure the predicted traffic speed does not exceed the 85 km/h safety threshold. Analyze how daily timestamps and neighbouring sensors influence the traffic speed predictions.
Program:
DATA0 = LOAD_SPATIOTEMPORAL_DATA(location="769806", time="2012-03-05 02:05:00", feature="traffic speed", region='BAY', time_int=5, period=1, unit="hours", constraints="None")
DATA1 = LOAD_SPATIAL_AUX_DATA(spatial_var="neighbour", location="769806", time="2012-03-05 02:05:00", feature='traffic speed', region='BAY', time_int=5, period=1, unit="hours", constraints="None")
INPUT_DATA = CREATE_FINAL_INPUT(data0=DATA0, spatial_data=DATA1, temporal_data="None")
FINAL_RESULT = RESULT(var=INPUT_DATA)
""",
]


def create_prompt(inputs, num_prompts=8, method='random',func_pool=False, example_type = "comb_tasks", seed=42, group=0):
    if method=='all':
        prompt_examples = ST_DATA_EXTRACT_EXAMPLES
    elif method=='random':
        random.seed(seed)
        prompt_examples = random.sample(ST_DATA_EXTRACT_EXAMPLES, num_prompts)
    else:
        raise NotImplementedError
    
    full_prompt = f"Follow the below examples to answer the question. Output only the corresponding Program for the given question.\n\nExamples:\n{prompt_examples}"

    # print(full_prompt + "\nQuestion: {question}\nProgram:".format(**inputs))
    
    return full_prompt + "\nQuestion: {question}\nProgram:".format(**inputs)
