

import numpy as np
import matplotlib.pyplot as plt
from scipy.signal import welch
from pathlib import Path


def compute_avg_psd_from_folder(folder_path, fs):

    folder = Path(folder_path)
    npy_files = sorted(folder.glob("*.npy"))
    psd_list = []

    for file in npy_files:
        data = np.load(file)
        # 计算 PSD，nperseg 取 min(1024, 数据长度)
        f_vals, Pxx = welch(data, fs=fs, nperseg=min(5120, len(data)))
        psd_list.append(Pxx)

    # 平均所有文件的 PSD
    avg_psd = np.mean(psd_list, axis=0)
    return f_vals, avg_psd


def determine_noise_bands_from_avg_psd(f_vals, avg_psd, fs):
    # 绘制 PSD 图（对数-对数图）
    plt.figure(figsize=(8, 6))
    plt.loglog(f_vals, avg_psd, 'b-', lw=1.5)
    plt.xlabel("Frequency (Hz)")
    plt.ylabel("PSD")
    plt.title("Average Power Spectral Density")
    plt.grid(True, which='both', ls='--')
    plt.show()
    return


if __name__ == "__main__":
    # 文件夹路径
    folder_path = r""
    fs = 100.0  # 采样频率

    # 计算平均 PSD
    f_vals, avg_psd = compute_avg_psd_from_folder(folder_path, fs)
    # 根据平均 PSD 绘制图像并初步确定噪声频段边界
    determine_noise_bands_from_avg_psd(f_vals, avg_psd, fs)