import os
import numpy as np
import pandas as pd


def main():
    # 输入和输出路径（请根据实际情况调整）
    input_excel = r"D:\MAE_acce\IP14\41.xlsx"
    output_dir = r"D:\MAE_acce\IP14\processed"
    os.makedirs(output_dir, exist_ok=True)

    # 1. 读取 Excel 文件，提取数据（假设数据在第一列）
    df = pd.read_excel(input_excel)
    # 将第一列数据提取为 numpy 数组，形状应为 (200000,)
    data = df.iloc[:, 0].values
    print("Original data shape:", data.shape)

    # 2. 数据归一化（z-score 标准化）
    mean = np.mean(data)
    std = np.std(data)
    data_norm = (data - mean) / std
    print("Data normalized. Mean: {:.4f}, Std: {:.4f}".format(np.mean(data_norm), np.std(data_norm)))

    # 3. 切分数据为长度为 512 的样本
    segment_length = 512
    num_samples = len(data_norm) // segment_length  # 取整数个样本
    print("Number of samples (discarding remainder):", num_samples)
    # 舍弃余下不足 512 的数据
    data_norm = data_norm[:num_samples * segment_length]
    # 将数据 reshape 成 (num_samples, 512)
    segments = data_norm.reshape(num_samples, segment_length)

    # 4. 保存每个样本为 .npy 文件
    for i, seg in enumerate(segments):
        output_file = os.path.join(output_dir, f"sample_{i:05d}.npy")
        np.save(output_file, seg)
    print(f"Saved {num_samples} samples to {output_dir}")


if __name__ == "__main__":
    main()
