# Supplementary Code Overview

This repository contains all code used in our  submission . The directory is organized as follows:
├── inference/ # Inference scripts
│ └── MoE_Gyro.py # Entry point for running both Peak and Denoise experts
│
├── models/ # Expert model definitions
│ ├── ORE.py # Peak Expert (Over-Range Reconstruction) model
│ └── DE.py # Denoise Expert model
│
├── training/ # Pretraining & training engines
│ ├── pretrain_ore.py # Data loader and training loop for ORE
│ ├── pretrain_de.py # Data loader and training loop for DE
│ ├── engine_pretrain_ore.py # Training engine utilities for ORE
│ └── engine_pretrain_de.py # Training engine utilities for DE
│
├── FFT_augmentation/ # FFT-based augmentation
│ ├── FFT.py # Compute FFT features for DE augmentation
│ ├── MIX.py # Mix FFT features into time-domain signals
│ └── Add_noise.py # Inject noise based on FFT statistics
│
└── testbench/ # Evaluation metrics
├── ISEBench_overrange.py # Over-range reconstruction metrics
├── ISEBench_weaksignal.py # Weak-signal (noise) suppression metrics
└── ISEBench_allan.py # Allan variance analysis



## Directory & File Descriptions

### 1. `inference/`

- **MoE_Gyro.py**  
  Launches the full inference pipeline by dynamically routing input segments to the two specialized experts (Peak and Denoise) and producing enhanced output signals.

### 2. `models/`

- **ORE.py**  
  Defines the Peak Expert model responsible for reconstructing saturated peaks using a Masked Autoencoder architecture.

- **DE.py**  
  Defines the Denoise Expert model that suppresses noise while preserving fine-grained signal details, leveraging complementary masking strategies.

### 3. `training/`

- **pretrain_ore.py**  
  Prepares datasets and implements the training loop for the Peak Expert (ORE).

- **pretrain_de.py**  
  Prepares datasets and implements the training loop for the Denoise Expert (DE), including FFT-based feature augmentation.

- **engine_pretrain_ore.py** / **engine_pretrain_de.py**  
  Contain reusable training engine functions (e.g., optimizer setup, learning-rate scheduling, checkpointing) shared across experiments.

### 4. `fft_augmentation/`

- **FFT.py**  
  Extracts frequency-domain features used to guide the Denoise Expert’s training.

- **MIX.py**  
  Applies mapping functions to integrate FFT features back into the time domain for augmented training samples.

- **Add_noise.py**  
  Generates synthetic noise profiles informed by FFT statistics to further challenge the Denoise Expert.

### 5. `testbench/`

- **ISEBench_overrange.py**  
  Computes peak reconstruction quality metrics (e.g., PSNR, correlation) on clipped signals.

- **ISEBench_weaksignal.py**  
  Evaluates weak-signal recovery performance (e.g., SNR improvements) after denoising.

- **ISEBench_allan.py**  
  Performs Allan variance analysis to quantify noise characteristics over different integration times.

---

## Data Availability

All datasets referenced in the paper will be publicly released upon publication. Instructions for downloading and preprocessing the data will be provided in the final repository.

## Usage

**Run inference**

```
python MoE_Gyro.py \
  --peak_ckpt   /path/to/peak_expert.pth \
  --denoise_ckpt /path/to/denoise_expert.pth \
  --input       /path/to/input_signal.npy \
  --output      /path/to/output_fused.npy \
```

---



**Run training**

```

python pretrain_ore/de.py --model  --batch_size  --epochs 
```

