import copy
from typing import List

import numpy as np
import torch
from mani_skill.agents.base_agent import BaseAgent
from mani_skill.agents.controllers import PDJointPosControllerConfig
from mani_skill.agents.registration import register_agent
from mani_skill.utils import sapien_utils
from mani_skill.utils.structs.pose import vectorize_pose

from utils.allegro import AllegroHand


@register_agent()
class AllegroHand2(AllegroHand):
    uid = "allegro_hand_2"

    @property
    def _controller_configs(self):
        trans_pd = PDJointPosControllerConfig(
            self.trans_joint_names,
            lower=[-10, -10, -10],
            upper=[10, 10, 10],
            stiffness=2000,
            damping=100,
            force_limit=1000,
            normalize_action=True,
        )

        controller_dict = dict(
            pd_joint_pos=dict(
                trans=trans_pd,
                rot=super()._controller_configs["pd_joint_pos"]["rot"],
                finger=super()._controller_configs["pd_joint_pos"]["finger"],
            ),
        )
        return copy.deepcopy(controller_dict)
