import os

import cv2

# Path to the first video
video_path = "real_videos/20250515_114750.mp4"

# Open the video
cap = cv2.VideoCapture(video_path)

# Get video FPS
fps = cap.get(cv2.CAP_PROP_FPS)

# Read the first frame
ret, frame = cap.read()

if ret:
    os.makedirs("cropped_frames", exist_ok=True)
    height, width = frame.shape[:2]

    crop_width = int(width * 0.8)
    crop_height = int(height * 0.9)

    start_x = (width - crop_width) // 2
    start_y = height - crop_height
    crop_width = int(width * 0.6)  # Changed from 0.8 to 0.6 to crop 20% more on right

    cropped_frame = frame[
        start_y : start_y + crop_height, start_x : start_x + crop_width
    ]
    output_path = "cropped_frames/first_frame_cropped.jpg"
    cv2.imwrite(output_path, cropped_frame)

    cap.set(cv2.CAP_PROP_POS_MSEC, 7000)  # 1000 milliseconds = 1 second
    ret, frame = cap.read()
    cropped_frame = frame[
        start_y : start_y + crop_height, start_x : start_x + crop_width
    ]
    output_path = "cropped_frames/second_frame_cropped.jpg"
    cv2.imwrite(output_path, cropped_frame)

    cap.set(cv2.CAP_PROP_POS_MSEC, 11500)  # 15000 milliseconds = 15 seconds
    ret, frame = cap.read()
    cropped_frame = frame[
        start_y : start_y + crop_height, start_x : start_x + crop_width
    ]
    output_path = "cropped_frames/third_frame_cropped.jpg"
    cv2.imwrite(output_path, cropped_frame)

    cap.set(cv2.CAP_PROP_POS_MSEC, 13000)  # 15000 milliseconds = 15 seconds
    ret, frame = cap.read()
    cropped_frame = frame[
        start_y : start_y + crop_height, start_x : start_x + crop_width
    ]
    output_path = "cropped_frames/fourth_frame_cropped.jpg"
    cv2.imwrite(output_path, cropped_frame)

    cap.set(cv2.CAP_PROP_POS_MSEC, 15000)  # 15000 milliseconds = 15 seconds
    ret, frame = cap.read()
    cropped_frame = frame[
        start_y : start_y + crop_height, start_x : start_x + crop_width
    ]
    output_path = "cropped_frames/fifth_frame_cropped.jpg"
    cv2.imwrite(output_path, cropped_frame)

cap.release()
