import os
from pathlib import Path

import cv2
import numpy as np


def process_videos():
    # Create output directory if it doesn't exist
    output_dir = Path("processed_videos")
    output_dir.mkdir(exist_ok=True)

    # Get all video files from real_videos directory
    input_dir = Path("real_videos")
    video_files = list(input_dir.glob("*.mp4"))

    for video_path in video_files:
        print(f"Processing {video_path.name}...")

        # Open the video file
        cap = cv2.VideoCapture(str(video_path))

        # Get video properties
        fps = cap.get(cv2.CAP_PROP_FPS)
        width = int(cap.get(cv2.CAP_PROP_FRAME_WIDTH))
        height = int(cap.get(cv2.CAP_PROP_FRAME_HEIGHT))

        # Read all frames into memory
        frames = []
        while cap.isOpened():
            ret, frame = cap.read()
            if not ret:
                break
            frames.append(frame)

        cap.release()

        if not frames:
            print(f"Warning: No frames read from {video_path.name}")
            continue

        # Create output video writer
        output_path = output_dir / video_path.name
        fourcc = cv2.VideoWriter_fourcc(*"mp4v")
        out = cv2.VideoWriter(str(output_path), fourcc, fps, (width, height))

        # Write all frames
        for frame in frames:
            out.write(frame)

        out.release()
        print(f"Finished processing {video_path.name} - {len(frames)} frames processed")


if __name__ == "__main__":
    process_videos()
