## README

### Installation

```python
pip install -r requirements.txt
```



###  Experiment Reproduction

#### Sec 2 Overall Performance

```python
python stat.py --stat early_exp
```

#### Sec 3.3 Input Question

```python
python stat.py --stat bon_dif_acc --model YOUR_MODEL  ## Best-of-N Experiments 
python stat.py --stat mcts_dif_acc --model YOUR_MODEL  ## MCTS Experiments 
```

#### Sec 3.4 Sampling Number

```python
python stat.py --stat sample_acc --model YOUR_MODEL  ## Best-of-N Experiments 
python stat.py --stat search_acc --model YOUR_MODEL  ## MCTS Experiments
python stat.py --stat rollnum_timeline --model YOUR_MODEL ## Discriminative Performance
python stat.py --stat longtail_stat --model YOUR_MODEL ## Inverse Long-tail Phenomenon
```

#### Sec 3.5 Search Parameters

```python
python stat.py --stat temp_acc --model YOUR_MODEL  ## Temperature Experiments 
python stat.py --stat mcts_shape_acc --model YOUR_MODEL  ## MCTS Shape Experiments
```

#### Sec 4.2 Main Experiments

Please refer to the python file for specific methods and hyperparameters.

```python
python llm_reason.py --method METHOD --model YOUR_MODEL --dataset YOUR_DATASET
```

