#!/bin/bash

HOME_DIR="/home/user/code/align_or_not"

# CoMM training -- Affect datasets
for dataset in "mosi" "mimic" "sarcasm" "humor"; do
  for i in {0..4}; do
    CUDA_VISIBLE_DEVICES=0 HYDRA_FULL_ERROR=1 python3 ${HOME_DIR}/main_multibench.py \
                data.data_module.dataset=${dataset} \
                +exp_name="drop+noise/run-${i}"\
                seed=$((42+$i)) \
                +trainer.num_sanity_val_steps=1 \
                linear_probing.frequency="by_epoch" \
                model="comm" \
                trainer.max_epochs=100 \
                optim.lr=1e-3 \
                optim.weight_decay=1e-2
  done
done

# CoMM training -- Vision&Touch dataset
for i in {0..4}; do
  CUDA_VISIBLE_DEVICES=0 HYDRA_FULL_ERROR=1 python3 ${HOME_DIR}/main_multibench.py \
                  model="comm" \
                  model.model.encoder.embed_dim=128 \
                  +visionandtouch.encoders.0.global_pool="" \
                  data.data_module.dataset="visionandtouch" \
                  +trainer.num_sanity_val_steps=1 \
                  +trainer.check_val_every_n_epoch=5 \
                  seed=$((42+$i)) \
                  +exp_name="run-${i}"\
                  mode="train" \
                  trainer.max_epochs=200 \
                  optim.lr=1e-4 \
                  optim.weight_decay=1e-2 \
                  linear_probing._target_=evaluation.linear_probe_reg.LinearProbingRegCallback \
                  linear_probing.use_sklearn=true \
                  ~linear_probing.fastsearch
done
