#!/bin/bash

HOME_DIR="/home/user/code/align_or_not"


## Humor dataset
for run in {0..4}; do
    seed=$((42+${run}))
    CUDA_VISIBLE_DEVICES=0 HYDRA_FULL_ERROR=1 python3 ${HOME_DIR}/main_multibench_all-mod.py \
                data.data_module.dataset="humor" \
                +exp_name="all-modalities/run-${run}" \
                data.data_module.batch_size=64 \
                +model="comm" \
                seed=${seed} \
                model.model.encoder.embed_dim=40 \
                trainer.max_epochs=200 \
                optim.lr=1e-3 \
                optim.weight_decay=1e-2
done

# Vision&Touch dataset (next-contact binary prediction)
CUDA_VISIBLE_DEVICES=0 HYDRA_FULL_ERROR=1 python3 ${HOME_DIR}/main_multibench_all-mod.py \
                data.data_module.dataset="visionandtouch-bin" \
                visionandtouch-bin.adapters.1._target_=models.input_adapters.SimpleFeaturesInputAdapter \
                visionandtouch-bin.encoders.1.z_dim=512 \
                ~visionandtouch-bin.adapters.1.n_features \
                ~visionandtouch-bin.adapters.1.dim_tokens \
                +exp_name="all-modalities" \
                +trainer.num_sanity_val_steps=1 \
                +trainer.check_val_every_n_epoch=5 \
                +model="comm" \
                model.model.encoder.embed_dim=512 \
                trainer.max_epochs=200 \
                optim.lr=1e-4 \
                optim.weight_decay=1e-2

