# Catalytic Role of Noise and Necessity of Inductive Biases in the Emergence of Compositional Communication

This repository contains a code for the paper Catalytic Role of Noise and Necessity of
Inductive Biases in the Emergence of Compositional Communication.

Below are the commands that allows to run the experiments from the paper.
Type `python run.py --help` to see the configuration options.

## Requirements

To install requirements:
`pip install -r requirements.txt`

## Training and evaluation

Use the instructions below to run experiments from the paper.

### Appendix D.1 Main experiment
* To run the master experiment with `shapes3d` dataset, use this command:
`python run.py`

* To run master experiment with `obverter` dataset, use this command:
`python run.py --load.name obverter10k --load.train_features "{'label_shape': [0, 1, 2, 3], 'label_color': [0, 1, 2, 3]}"`

### Appendix D.2 Different number of symbols

* To run 4x4 experiment, use this command:
`python run.py --load.sender_alphabet_size 4`

* To run 8x8 experiment, use this command:
`python run.py --load.sender_alphabet_size 8`

### Appendix D.4 Sensitivity with respect to small architecture changes

* To run experiment with bigger CNN, use this command:
`python run.py --Sender.conv_filters "[16, 16]"`

* To run experiment with bigger dense layer, use this command:
`python run.py --Receiver.hidden_sizes "[64, 64]"`

### Appendix D.5 Sensitivity to noisy channel implementation

* To run experiment with alternative noise implementation, use this command:
`python run.py --noisy_channel.new_noise 0.002`

### Appendix D.6 Longer message

* To run experiment with message length three, use this command:
`python run.py --load.train_features "{'label_shape': [0, 1, 2, 3], 'label_object_hue': [0, 1, 2, 3], 'label_floor_hue': [0, 1, 2, 3]}"`

* To run experiment with message length four, use this command:
`python run.py --load.train_features "{'label_shape': [0, 1, 2, 3], 'label_object_hue': [0, 1, 2, 3], 'label_floor_hue': [0, 1, 2, 3], 'label_wall_hue': [0, 1, 2, 3]}"`

### Appendix D.7 Visual priors

* To run experiment with visual prior scramble with tile 32, use this command:
`python run.py --load.image_transform_fn "@scramble_image" --scramble_image.tile_size "[32, 32]"`

* To run experiment with visual prior scramble with tile 16, use this command:
`python run.py --load.image_transform_fn "@scramble_image" --scramble_image.tile_size "[16, 16]"`

* To run experiment with visual prior scramble with tile 8, use this command:
`python run.py --load.image_transform_fn "@scramble_image" --scramble_image.tile_size "[8, 8]"`

### Appendix D.8 Scrambled features

* To run experiment with features scramble, use this command:
`python run.py --load.features_transform_fn "@features_scramble"`


## Contributing

This project is licensed under the terms of the MIT license.
