"""Schedulers"""

import math
import numpy as np
import tensorflow as tf

import gin


def callable_or_constant(val, convert_to_tensor=False, dtype=None):
    if callable(val):
        callable_ = val
    else:
        callable_ = lambda _, __: val

    if convert_to_tensor:
        return lambda x, y: tf.constant(callable_(x, y), dtype=dtype)
    else:
        return callable_


@gin.configurable
def random_scheduler(epoch, training_steps, probability):  # pylint: disable=unused-argument
    return np.random.uniform() < probability


@gin.configurable
def periodic_scheduler(epoch, training_steps, period=2):  # pylint: disable=unused-argument
    return training_steps % period == 0


@gin.configurable
def example_sine_noise_scheduler(epoch, training_steps, magnitude):
    """Example for tests and fun"""

    del training_steps
    return magnitude - magnitude * math.sin(epoch * 0.1)


@gin.configurable
def linear_scheduler(epoch, training_steps, start_value,
                     stop_value, period, warmup=0):
    """ Linear scheduler"""

    del epoch

    x = min(max(training_steps-warmup, 0), period)

    return start_value + (stop_value - start_value) * (x/period)
