"""Tests...."""

from ncc.compositionality_metrics import get_protocol # pylint: disable=import-only-modules
from ncc.compositionality_metrics import conflict_count


def test_conflict_count():
    cc = conflict_count.ConflictCount()
    proto = []
    proto += get_protocol([[0, 0]], [['x', 'A']],
            {'color': 'ups', 'shape': 'pups'})
    proto += get_protocol([[0, 1]], [['x', 'B']],
            {'color': 'ups', 'shape': 'pups'})
    proto += get_protocol([[1, 0]], [['y', 'A']],
            {'color': 'ups', 'shape': 'pups'})
    proto += get_protocol([[1, 1]], [['y', 'B']],
            {'color': 'ups', 'shape': 'pups'})
    assert cc.measure(proto) == 0

    proto = get_protocol([(0, 0), (0, 1), (1, 0), (1, 1)],
                         [(0, 0), (0, 1), (1, 0), (1, 1)],
                         {'color':'ups', 'shape':'pups'})
    assert cc.measure(proto) == 0

    proto = get_protocol([(0, 0), (0, 1), (1, 0), (1, 1)],
                         [(0, 0), (1, 1), (0, 0), (1, 1)],
                         {'color':'ups', 'shape':'pups'})
    assert cc.measure(proto) == 2

    proto = get_protocol([(0, 0), (0, 1), (0, 2), (1, 0), (1, 1),
                          (1, 2), (2, 0), (2, 1), (2, 2)],
                         [(0, 0), (0, 1), (0, 2), (1, 0), (1, 1),
                          (1, 2), (2, 0), (2, 1), (2, 2)],
                         {'color':'ups', 'shape':'pups'})
    assert cc.measure(proto) == 0


    proto = get_protocol([(0, 0), (0, 1), (0, 2), (0, 0), (0, 1),
                          (0, 2), (0, 0), (0, 1), (0, 2)],
                         [(0, 0), (0, 1), (0, 2), (1, 0), (1, 1),
                          (1, 2), (2, 0), (2, 1), (2, 2)],
                         {'color':'ups', 'shape':'pups'})
    assert cc.measure(proto) == 6
