"""Data handling."""

import gin

from ncc.data import loader
from ncc.data import transformation


# Configure transformations in this module to ensure they're accessible via the
# ncc.data.* namespace.
def configure_transformation(agent_class):
    return gin.external_configurable(
        agent_class, module='ncc.data'
    )


UpdateMNISTColors = configure_transformation(
    transformation.UpdateMNISTColors)  # pylint: disable=invalid-name
