"""
From https://github.com/openai/spinningup/blob/master/spinup/utils/logx.py
"""

import json

import tensorflow as tf


def convert_json(obj):
    """ Convert obj to a version which can be serialized with JSON. """
    if is_json_serializable(obj):
        return obj
    else:
        if isinstance(obj, dict):
            return {convert_json(k): convert_json(v)
                    for k, v in obj.items()}

        elif isinstance(obj, tuple):
            return (convert_json(x) for x in obj)

        elif isinstance(obj, list):
            return [convert_json(x) for x in obj]

        elif isinstance(obj, tf.data.Dataset):
            # pylint: disable=protected-access # Todo: this should be checked.
            return {str(obj): str(obj._tf_api_names)}

        elif hasattr(obj, '__name__') and not 'lambda' in obj.__name__:
            return convert_json(obj.__name__)

        elif hasattr(obj, '__dict__') and obj.__dict__:
            obj_dict = {convert_json(k): convert_json(v)
                        for k, v in obj.__dict__.items()}
            return {str(obj): obj_dict}

        return str(obj)


def is_json_serializable(v):
    try:
        json.dumps(v)
        return True
    except: # pylint: disable=bare-except
        return False
