"""Todo: fill me please"""

import logging

import matplotlib.pyplot as plt
import pandas as pd

from ncc.utils import config_log
from ncc.utils import latex

logger = logging.getLogger(__name__)

DATAFRAME = None


def cross_table(df, name, epoch, test_labels):
    # pylint: disable=missing-function-docstring #TODO: fix this
    df['s'] = df['s1'].map(str) + ',' + df['s2'].map(str)
    df = df[['color', 'shape', 's']]

    df2 = df.groupby(['color', 'shape']).agg(
        lambda x: x.value_counts(normalize=False).to_dict()).unstack()
    df2.columns = df2.columns.droplevel()
    logger.debug('cross table dataframe %s', df2)

    fig, ax = plt.subplots(figsize=(20, 5))
    ax.axis('off')
    df_color = df2.copy()
    df_color.loc[:, :] = 'xkcd:silver'
    for c, s in test_labels:
        df_color.at[c, s] = 'xkcd:azure'
    # logger.debug('colors \n%s', dfColor)

    t = pd.plotting.table(ax, df2, bbox=[0, 0, 1, 1],
                          rowColours=['xkcd:silver'] * df2.shape[0],
                          colColours=['xkcd:silver'] * df2.shape[1],
                          cellColours=df_color.values
                          )
    t.auto_set_font_size(False)
    t.set_fontsize(12)
    fig.suptitle(f'{name} epoch {epoch}')
    # plt.show(fig)
    df3 = df2.copy()

    def format_cell(x):
        max_no = max_sym = None
        for k, v in x.items():
            if max_no is None or max_no < v:
                max_sym = k
                max_no = v
        # ret = [f'{k}:{v}' for k,v in x.items()]
        return max_sym
        # return ', '.join(ret)

    df3 = df3.applymap(format_cell)
    comm = f'% generated from {DATAFRAME}\n'
    logger.debug('LaTeX\n%s', comm + latex.table_header +
                 df3.to_latex() + latex.table_footer)

    return fig


if __name__ == '__main__':
    import sys

    config_log.config_log()
    df = pd.read_pickle(sys.argv[1])
    DATAFRAME = sys.argv[1]
    fig = cross_table(df, 'train', '', [])
    # plt.show()
