"""Training algorithm module."""

import gin

from ncc.algos import noisy_channel

# Configure agents in this module to ensure they're accessible via the
# ncc.algos.agents.* namespace.
def configure_algo(algo_class):
    return gin.external_configurable(
        algo_class, module='ncc.algos'
    )


noisy_channel = configure_algo(
    noisy_channel.noisy_channel)  # pylint: disable=invalid-name
