"""Base classes and types for compositionality metrics"""


import abc

from typing import Tuple, List  # pylint: disable=import-only-modules


Derivation = Tuple[str, str]
Message = str
Interaction = Tuple[Derivation, str]
Protocol = List[Interaction]


class Metric(abc.ABC):

    name: str

    @abc.abstractmethod
    def measure(self, protocol: Protocol) -> float:
        raise NotImplementedError()
