"""Todo: fill me please"""

import logging.config
import os


def config_log(fname='/dev/null', level='INFO'):
    logging.config.dictConfig({
        'version': 1,
        'disable_existing_loggers': False,
        'formatters': {
            'verbose': {
                'format': '%(asctime)s %(levelname)6s  %(process)6d %(message)s'
            }
        },
        'handlers': {
            'console': {
                'level': 'DEBUG',
                'class': 'logging.StreamHandler',
                'formatter': 'verbose',
            },
            'file': {
                'level': 'DEBUG',
                'class': 'logging.handlers.RotatingFileHandler',
                'formatter': 'verbose',
                'filename': fname,
                'maxBytes': 0
            }
        },
        'loggers': {
            '': {
                'level': level,
                'handlers': ['console'] + ['file'] if fname else [],
                'propagate': True,
            },

            'ncc': {'level': os.getenv('LOGLEVEL', 'INFO')},
            '__main__': {'level': os.getenv('LOGLEVEL', 'INFO')},

        }
    })
