# Unbiased Supervised Contrastive Learning

Instructions for ImageNet-100, BiasedMNIST, Corrupted-CIFAR 10, bFFHQ and 9-Class Imagenet.

We provide basic instructions for running the code below. 

In this code: 

- `--method=infonce` is $\epsilon$-SupInfoNCE, and `--method=infonce-strong` is $\epsilon$-SupCon.

- `--kld=1` uses the full debiasing term, while `--kld=0` only the condition on the means.


## ImageNet-100

```bash
python3 main_infonce.py \
    --dataset imagenet100 \
    --data_dir /path/to/imagenet --epochs 100 --model resnet50 \
    --lr 0.1 --optimizer sgd --batch_size 256 --method infonce \
    --weight_decay 1e-4 \
    --form out --temp 0.1 --epsilon 0.25 \
    --log_dir logs \
    --lr_decay step --lr_decay_epochs 30,60,90 \
    --mlp_lr 0.001 --mlp_optimizer adam --mlp_max_iter 500 \
    --feat_dim 2048 \
    --mlp_batch_size 2048 --test_freq 1 \
    --train_on_head 1 \
    --trial 0
```

## BiasedMNIST

```
python3 main_infonce.py --alpha=0.01 --batch_size=256 \
    --beta=0 --data_dir=/data --dataset=biased-mnist_0.999 \
    --epochs=80 --epsilon=0 --form=out --kld=0 --lambd=0.5 \
    --lr=0.001 --lr_decay=step --lr_decay_epochs=26,53 \
    --method=infonce --model=simpleconvnet --optimizer=adam \
    --temp=0.1 --test_freq=1 --trial=0 --weight_decay=1e-05 --amp
```

## Corrupted CIFAR- 10

Download from: https://drive.google.com/file/d/1_eSQ33m2-okaMWfubO7b8hhvLMlYNJP-/view?usp=sharing

```
python3 main_infonce.py --alpha=0.01 --batch_size=256 \
    --beta=0 --data_dir=/data --dataset=biased-mnist_0.999 \
    --epochs=80 --epsilon=0 --form=out --kld=0 --lambd=0.5 \
    --lr=0.001 --lr_decay=step --lr_decay_epochs=26,53 \
    --method=infonce --model=simpleconvnet --optimizer=adam \
    --temp=0.1 --test_freq=1 --trial=0 \
    --weight_decay=1e-05 --amp
```

## BFFHQ

Download from: https://drive.google.com/file/d/1hRmeIxhoa6YsyAm2LUPqa7nY1KtOpp6G/view?usp=sharing

```
python3 main_infonce.py --alpha=0.01 --batch_size=64 \
    --beta=0.1 --data_dir=/data --dataset=bffhq_0.5pct \
    --epochs=100 --epsilon=0 --kld=1 --lambd=1 --lr=0.0001 \
    --lr_decay=cosine --lr_decay_epochs=100,150 \
    --model=resnet18 --optimizer=adam --trial=0 \
    --weight_decay=0 --amp
```

# 9-Class Imagenet

1) Download imagenet dataset. 

2) Download imagenet-a https://people.eecs.berkeley.edu/~hendrycks/imagenet-a.tar and untar

3) Obtained biased features by running `get_imagenet_bias_features.py` from https://github.com/grayhong/bias-contrastive-learning (set seeds)

4) Change line 78 in `main_infonce_imagenet9.py` with the correct path and run fairkl.

```
python3 main_infonce_imagenet9.py --alpha=0.5 --batch_size=256 --data_dir=/folder/containing/imagenet-and-imagenet-a --epochs=200 --epsilon=0.1 --kld=1 --lambd=1 --lr=0.001 --lr_decay=cosine --method=infonce --mlp_lr=0.01 --mlp_optimizer=sgd --model=resnet18 --optimizer=adam --temp=0.1 --train_on_head=1 --trial=1 --weight_decay=0.0001 --aug 0
```